/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v1;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.esf.model.invoice.version.v1.CustomerTypeV1;
import ru.uss.esf.model.invoice.version.v1.CustomerV1;
import ru.uss.esf.validation.invoice.version.v1.CustomerTinV1;

public class CustomerTinValidatorV1
implements ConstraintValidator<CustomerTinV1, CustomerV1> {
    public void initialize(CustomerTinV1 customerTinV1) {
    }

    public boolean isValid(CustomerV1 customer, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (customer.getStatuses() == null) {
            return true;
        }
        if (customer.getStatuses().contains(CustomerTypeV1.NONRESIDENT)) {
            if (customer.getTin() != null) {
                context.buildConstraintViolationWithTemplate("{customerV1.tin.isNotNull.forNonResident}").addPropertyNode("tin").addConstraintViolation();
                return false;
            }
        } else if (customer.getTin() == null) {
            context.buildConstraintViolationWithTemplate("{customerV1.tin.notNull}").addPropertyNode("tin").addConstraintViolation();
            return false;
        }
        return true;
    }
}

