/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v1;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.esf.model.invoice.version.v1.CustomerTypeV1;
import ru.uss.esf.model.invoice.version.v1.CustomerV1;
import ru.uss.esf.model.invoice.version.v1.InvoiceV1;
import ru.uss.esf.validation.invoice.version.v1.NonResidentCurrencyV1;

public class NonResidentCurrencyValidatorV1
implements ConstraintValidator<NonResidentCurrencyV1, InvoiceV1> {
    public void initialize(NonResidentCurrencyV1 constraintAnnotation) {
    }

    public boolean isValid(InvoiceV1 invoice, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (invoice.getCustomers() == null || invoice.getCustomers().size() != 1) {
            return true;
        }
        if (invoice.getSellers() == null || invoice.getSellers().size() != 1) {
            return true;
        }
        CustomerV1 customer = invoice.getCustomers().get(0);
        if (customer.getStatuses() == null || invoice.getProductSet() == null || invoice.getProductSet().getCurrencyCode() == null) {
            return true;
        }
        boolean isExporter = invoice.isForExport();
        if (customer.getStatuses().contains(CustomerTypeV1.NONRESIDENT) && !invoice.getProductSet().getCurrencyCode().equalsIgnoreCase("KZT") && !isExporter) {
            context.buildConstraintViolationWithTemplate("{invoiceV1.customers.nonResidentCurrency}").addPropertyNode("customers[0].statuses").addConstraintViolation();
            return false;
        }
        return true;
    }
}

