/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v1;

import java.util.Calendar;
import java.util.Date;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.utils.DateTimeUtils;
import ru.uss.esf.model.invoice.version.v1.InvoiceV1;
import ru.uss.esf.validation.invoice.version.v1.TurnoverDateV1;

public class TurnoverDateValidatorV1
implements ConstraintValidator<TurnoverDateV1, InvoiceV1> {
    public void initialize(TurnoverDateV1 constraintAnnotation) {
    }

    public boolean isValid(InvoiceV1 invoice, ConstraintValidatorContext context) {
        if (invoice.getTurnoverDate() == null || invoice.getDate() == null) {
            return true;
        }
        Date turnoverDate = DateTimeUtils.startOfTheDay(invoice.getTurnoverDate());
        Date date = DateTimeUtils.startOfTheDay(invoice.getDate());
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, -5);
        Date dateMinus5Years = cal.getTime();
        return turnoverDate.compareTo(date) <= 0 && turnoverDate.compareTo(dateMinus5Years) >= 0;
    }
}

