/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v1.field;

import java.util.HashSet;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.esf.model.invoice.version.v1.SellerTypeV1;
import ru.uss.esf.validation.invoice.version.v1.field.SellerTypesV1;

public class SellerTypesValidatorV1
implements ConstraintValidator<SellerTypesV1, List<SellerTypeV1>> {
    public void initialize(SellerTypesV1 constraintAnnotation) {
    }

    public boolean isValid(List<SellerTypeV1> statusList, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (statusList != null) {
            if (statusList.isEmpty()) {
                context.buildConstraintViolationWithTemplate("{sellerV1.statuses.emptyList}").addConstraintViolation();
                return false;
            }
            if (statusList.contains(null)) {
                context.buildConstraintViolationWithTemplate("{sellerV1.statuses.containsNull}").addConstraintViolation();
                return false;
            }
            if (statusList.size() != new HashSet<SellerTypeV1>(statusList).size()) {
                context.buildConstraintViolationWithTemplate("{sellerV1.statuses.isDuplicated}").addConstraintViolation();
                return false;
            }
            if (statusList.contains(SellerTypeV1.COMMITTENT) && statusList.contains(SellerTypeV1.BROKER)) {
                context.buildConstraintViolationWithTemplate("{sellerV1.statuses.commitentAndBrokerMutualExclusive}").addConstraintViolation();
                return false;
            }
        }
        return true;
    }
}

