/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2;

import java.util.Collections;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.utils.RegistrationNumberUtils;
import ru.uss.esf.model.invoice.version.v2.CustomerTypeV2;
import ru.uss.esf.model.invoice.version.v2.InvoiceV2;
import ru.uss.esf.model.invoice.version.v2.SellerTypeV2;
import ru.uss.esf.validation.invoice.version.v2.CurrencyCodeV2;

public class CurrencyCodeValidatorV2
implements ConstraintValidator<CurrencyCodeV2, InvoiceV2> {
    public void initialize(CurrencyCodeV2 constraintAnnotation) {
    }

    public boolean isValid(InvoiceV2 invoice, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (invoice.getProductSet() == null || invoice.getProductSet().getCurrencyCode() == null) {
            return true;
        }
        if (invoice.getSellers() == null || invoice.getSellers().size() == 0) {
            return true;
        }
        boolean canExport = invoice.contains(SellerTypeV2.FOR_EXPORT);
        if (canExport || invoice.containsCustomerStatus(Collections.singletonList(CustomerTypeV2.SHARING_AGREEMENT_PARTICIPANT))) {
            if (invoice.getProductSet().getCurrencyCode() == null) {
                context.buildConstraintViolationWithTemplate("{productSetV2.currencyCode.notNull}").addPropertyNode("productSet.currencyCode").addConstraintViolation();
                return false;
            }
        } else if (!"KZT".equals(invoice.getProductSet().getCurrencyCode()) && !RegistrationNumberUtils.isSnt(invoice.getDeliveryDocNum())) {
            context.buildConstraintViolationWithTemplate("{invoiceV2.products.currencyCode.invalid}").addPropertyNode("productSet.currencyCode").addConstraintViolation();
            return false;
        }
        return true;
    }
}

