/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2;

import java.util.Arrays;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.esf.model.invoice.version.v2.CustomerTypeV2;
import ru.uss.esf.model.invoice.version.v2.CustomerV2;
import ru.uss.esf.validation.common.field.TinValidator;
import ru.uss.esf.validation.invoice.version.v2.CustomerTinV2;

public class CustomerTinValidatorV2
implements ConstraintValidator<CustomerTinV2, CustomerV2> {
    private List<CustomerTypeV2> REQUIRED_TIN_WITH_RETAIL_STATUSES = Arrays.asList(CustomerTypeV2.COMMITTENT, CustomerTypeV2.BROKER, CustomerTypeV2.JOINT_ACTIVITY_PARTICIPANT, CustomerTypeV2.PUBLIC_OFFICE);

    public void initialize(CustomerTinV2 customerTinV2) {
    }

    public boolean isValid(CustomerV2 customer, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean result = true;
        if (customer == null) {
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)customer.getTin()) && customer.getStatuses() != null && customer.getStatuses().contains(CustomerTypeV2.RETAIL) && CollectionUtils.containsAny(this.REQUIRED_TIN_WITH_RETAIL_STATUSES, customer.getStatuses()) && (!customer.getStatuses().contains(CustomerTypeV2.BROKER) || !customer.isNonResident())) {
            context.buildConstraintViolationWithTemplate("{customerV2.tin.notNull}").addPropertyNode("tin").addConstraintViolation();
            result = false;
        }
        if (customer.getStatuses() != null && customer.getStatuses().contains(CustomerTypeV2.NONRESIDENT)) {
            if (customer.getTin() != null && customer.getTin().length() > 50) {
                context.buildConstraintViolationWithTemplate("{customerV2.tin.range}").addPropertyNode("tin").addConstraintViolation();
                result = false;
            }
        } else if (customer.getStatuses() != null && customer.getStatuses().contains(CustomerTypeV2.RETAIL)) {
            if (!StringUtils.isEmpty((CharSequence)customer.getTin()) && !TinValidator.isTin(customer.getTin())) {
                context.buildConstraintViolationWithTemplate("{customerV2.tin.format}").addPropertyNode("tin").addConstraintViolation();
                result = false;
            }
        } else if (StringUtils.isEmpty((CharSequence)customer.getTin())) {
            context.buildConstraintViolationWithTemplate("{customerV2.tin.notNull}").addPropertyNode("tin").addConstraintViolation();
            result = false;
        } else if (!TinValidator.isTin(customer.getTin())) {
            context.buildConstraintViolationWithTemplate("{customerV2.tin.format}").addPropertyNode("tin").addConstraintViolation();
            result = false;
        }
        return result;
    }
}

