/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.invoice.version.v2;

import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.esf.model.invoice.version.v2.InvoiceV2;
import ru.uss.esf.model.invoice.version.v2.ProductV2;
import ru.uss.esf.validation.invoice.version.v2.NdsAmountV2;

public class NdsAmountValidatorV2
implements ConstraintValidator<NdsAmountV2, InvoiceV2> {
    public void initialize(NdsAmountV2 constraintAnnotation) {
    }

    public boolean isValid(InvoiceV2 invoice, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean valid = true;
        for (int i = 0; i < invoice.getProductSet().getProducts().size(); ++i) {
            int ndsRate;
            ProductV2 p = invoice.getProductSet().getProducts().get(i);
            int n = ndsRate = p.getNdsRate() == null ? 0 : p.getNdsRate();
            if (p.getTurnoverSize() == null || p.getNdsAmount() == null) continue;
            BigDecimal ndsAmount = p.getTurnoverSize().multiply(BigDecimal.valueOf(ndsRate)).divide(BigDecimal.valueOf(100L)).setScale(2, RoundingMode.HALF_UP);
            if (p.getNdsAmount().setScale(2).equals(ndsAmount)) continue;
            context.buildConstraintViolationWithTemplate("{invoiceV2.product.wrong.ndsAmount}").addPropertyNode("productSet.products[" + i + "].ndsAmount").addConstraintViolation();
            valid = false;
        }
        return valid;
    }
}

