/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.mpt;

import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.mpt.MptType;
import ru.uss.esf.model.mpt.abstractmpt.MptAbstractDocument;
import ru.uss.esf.validation.common.field.TinValidator;
import ru.uss.esf.validation.mpt.MptTinCheck;

public class MptTinCheckValidator
extends AbstractClassLevelValidator<MptTinCheck, MptAbstractDocument> {
    public void initialize(MptTinCheck annotation) {
    }

    public boolean isValid(MptAbstractDocument mptDocument, ConstraintValidatorContext context) {
        MptType type = mptDocument.getType();
        boolean validationResult = true;
        String supplierTin = mptDocument.getSupplierTin();
        if (StringUtils.isNotBlank((CharSequence)supplierTin)) {
            if (MptType.ACCEPTANCE_CERTIFICATE.equals((Object)type)) {
                validationResult = TinValidator.isTin(supplierTin);
            } else if (MptType.NOTIFICATION.equals((Object)type)) {
                int minSize = 8;
                int maxSize = 14;
                boolean bl = validationResult = supplierTin.length() <= maxSize && supplierTin.length() >= minSize;
            }
            if (!validationResult) {
                return this.setupContextWithValidationError(context, "supplierTin", "{mpt.supplier.tin.format}");
            }
        } else {
            validationResult = false;
        }
        return validationResult;
    }
}

