/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.dictionary.Country;
import ru.uss.esf.model.snt.version.v1.SntConsigneeV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntConsigneeTinCheckV1;

public class SntConsigneeTinValidatorV1
extends AbstractClassLevelValidator<SntConsigneeTinCheckV1, SntV1> {
    public void initialize(SntConsigneeTinCheckV1 constraintAnnotation) {
    }

    public boolean isValid(SntV1 sntV1, ConstraintValidatorContext context) {
        if (sntV1.getSntImport() == null && sntV1.getSntExport() == null && sntV1.getTransferType() == null) {
            return true;
        }
        SntConsigneeV1 consignee = sntV1.getConsignee();
        if (consignee == null || BooleanUtils.isNotTrue((Boolean)consignee.getNonResident())) {
            return true;
        }
        boolean isValid = true;
        List<String> eaecCountryCodes = Country.EAEC_COUNTRY_CODES;
        if (eaecCountryCodes.contains(consignee.getCountryCode())) {
            if (StringUtils.isBlank((CharSequence)consignee.getTin())) {
                isValid = this.setupContextWithValidationError(context, "consignee.tin", "{sntConsigneeV1.tin.nonresident}");
            } else if ("AM".equals(consignee.getCountryCode()) && (StringUtils.isBlank((CharSequence)consignee.getTin()) || consignee.getTin().length() != 8)) {
                isValid = this.setupContextWithValidationError(context, "consignee.tin", "{sntConsigneeV1.tin.length_am}");
            } else if ("BY".equals(consignee.getCountryCode()) && (StringUtils.isBlank((CharSequence)consignee.getTin()) || consignee.getTin().length() != 9)) {
                isValid = this.setupContextWithValidationError(context, "consignee.tin", "{sntConsigneeV1.tin.length_by}");
            } else if ("RU".equals(consignee.getCountryCode()) && (StringUtils.isBlank((CharSequence)consignee.getTin()) || consignee.getTin().length() != 10 && consignee.getTin().length() != 12)) {
                isValid = this.setupContextWithValidationError(context, "consignee.tin", "{sntConsigneeV1.tin.length_ru}");
            } else if ("KG".equals(consignee.getCountryCode()) && (StringUtils.isBlank((CharSequence)consignee.getTin()) || consignee.getTin().length() != 14)) {
                isValid = this.setupContextWithValidationError(context, "consignee.tin", "{sntConsigneeV1.tin.length_kg}");
            }
        }
        return isValid;
    }
}

