/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.consts.EsfConst;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.abstractsnt.SntType;
import ru.uss.esf.model.snt.version.v1.SntCustomerV1;
import ru.uss.esf.model.snt.version.v1.SntExportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntTransferTypeV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.common.field.TinValidator;
import ru.uss.esf.validation.snt.version.v1.SntCustomerTinCheckV1;

public class SntCustomerTinValidatorV1
extends AbstractClassLevelValidator<SntCustomerTinCheckV1, SntV1> {
    public static final Pattern TIN_PATTERN = Pattern.compile("[0-9]*");

    public void initialize(SntCustomerTinCheckV1 constraintAnnotation) {
    }

    public boolean isValid(SntV1 sntV1, ConstraintValidatorContext context) {
        String borderCrossingOperationType;
        if (sntV1.getCustomer() == null) {
            return true;
        }
        SntCustomerV1 customer = sntV1.getCustomer();
        if (customer.isRetail() && customer.getTin() == null) {
            if (customer.isIndividual()) {
                return this.setupContextWithValidationError(context, "customer.tin", "{sntCustomerV1.tin.isMissing}");
            }
            return true;
        }
        int tinLength = StringUtils.length((CharSequence)customer.getTin());
        if (BooleanUtils.isTrue((Boolean)customer.getNonResident())) {
            if (tinLength > 50) {
                return this.setupContextWithValidationError(context, "customer.tin", "{sntCustomerV1.tin.longMask}");
            }
        } else if (StringUtils.isBlank((CharSequence)customer.getTin())) {
            String ethanolOpCode = LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getAlcoholSet().getEthanolProductSet().getOperationCode());
            String beerOpCode = LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getAlcoholSet().getAlcoholBeerProductSet().getOperationCode());
            String exceptBeerOpCode = LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getAlcoholSet().getAlcoholExceptBeerProductSet().getOperationCode());
            String oilOpCode = LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getOilSet().getOperationCode());
            String biofuelOpCode = LambdaUtils.nullSafeApplyFunction(sntV1, snt -> snt.getBiofuelSet().getOperationCode());
            if (!("15".equals(ethanolOpCode) || "15".equals(beerOpCode) || "15".equals(exceptBeerOpCode) || "26".equals(oilOpCode) || "34".equals(biofuelOpCode))) {
                return this.setupContextWithValidationError(context, "customer.tin", "{sntCustomerV1.tin.isMissing}");
            }
        } else if (tinLength != 12) {
            return this.setupContextWithValidationError(context, "customer.tin", "{sntCustomerV1.tin.shortMask}");
        }
        if (sntV1.getSntType() == SntType.PRIMARY_SNT) {
            if (customer.isIndividual() && StringUtils.isNotEmpty((CharSequence)customer.getTin()) && Pattern.matches("[0-9]{12}", customer.getTin()) && !TinValidator.isIin(customer.getTin()) && !BooleanUtils.isTrue((Boolean)sntV1.getCustomer().getNonResident())) {
                return this.setupContextWithValidationError(context, "customer.tin", "{sntCustomerV1.tin.isNotForIndividual}");
            }
            if (StringUtils.isNotEmpty((CharSequence)customer.getTin()) && !TIN_PATTERN.matcher(customer.getTin()).matches()) {
                return this.setupContextWithValidationError(context, "customer.tin", "{snt.participant.tin.digitalFormatRequired}");
            }
        }
        List<String> controlBorderCrossingOperationTypes = Arrays.asList(SntExportTypeV1.EXPORT.name(), SntTransferTypeV1.ONE_PERSON_IN_EAEU.name());
        String string = sntV1.getSntExport() != null ? sntV1.getSntExport().getExportType().name() : (borderCrossingOperationType = sntV1.getTransferType() != null ? sntV1.getTransferType().name() : null);
        if (!SntType.RETURNED_SNT.equals(sntV1.getSntType()) && controlBorderCrossingOperationTypes.contains(borderCrossingOperationType) && BooleanUtils.isTrue((Boolean)LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getCustomer().getNonResident())) && EsfConst.EAEC_COUNTRY_CODES_WITHOUT_KZ.contains(LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getCustomer().getCountryCode()))) {
            if (StringUtils.isEmpty((CharSequence)LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getCustomer().getTin()))) {
                return this.setupContextWithValidationError(context, "customer.tin", "{sntCustomerV1.tin.requiredForEaec}");
            }
            boolean isRequireCheck = true;
            int requiredLength = 0;
            switch (sntV1.getCustomer().getRegisterCountryCode()) {
                case "AM": {
                    requiredLength = 8;
                    break;
                }
                case "BY": {
                    requiredLength = 9;
                    break;
                }
                case "RU": {
                    requiredLength = 10;
                    break;
                }
                case "KG": {
                    requiredLength = 14;
                    break;
                }
                default: {
                    isRequireCheck = false;
                }
            }
            if (isRequireCheck && sntV1.getCustomer().getTin().length() != requiredLength && (!"RU".equals(sntV1.getCustomer().getRegisterCountryCode()) || sntV1.getCustomer().getTin().length() != 12)) {
                return this.setupContextWithValidationError(context, "customer.tin", "{sntCustomerV1.tin.lengthForEaec." + sntV1.getCustomer().getRegisterCountryCode() + "}");
            }
        }
        return true;
    }

    public static void main(String[] args) {
        System.out.println(TIN_PATTERN.matcher("12321312").matches());
    }
}

