/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.version.v1.SntExportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntFillingOfAircraftCheckV1;

public class SntFillingOfAircraftValidatorV1
extends AbstractClassLevelValidator<SntFillingOfAircraftCheckV1, SntV1> {
    public void initialize(SntFillingOfAircraftCheckV1 constraintAnnotation) {
    }

    public boolean isValid(SntV1 snt, ConstraintValidatorContext context) {
        boolean isValid = true;
        SntExportTypeV1 sntExportTypeV1 = LambdaUtils.nullSafeApplyFunction(snt, sntV1 -> sntV1.getSntExport().getExportType());
        if (SntExportTypeV1.AIRCRAFT_REFUELING.equals(sntExportTypeV1)) {
            if (StringUtils.isEmpty((CharSequence)LambdaUtils.nullSafeApplyFunction(snt, sntV1 -> sntV1.getFillingOfAircraft().getAircraftRegistrationNumber()))) {
                this.addConstraintViolation(context, "fillingOfAircraft.aircraftRegistrationNumber", this.generateNotNullFieldMessage("sntFillingOfAircraftV1.aircraftRegistrationNumber"));
                isValid = false;
            }
            if (StringUtils.isEmpty((CharSequence)LambdaUtils.nullSafeApplyFunction(snt, sntV1 -> sntV1.getFillingOfAircraft().getAircraftType()))) {
                this.addConstraintViolation(context, "fillingOfAircraft.aircraftType", this.generateNotNullFieldMessage("sntFillingOfAircraftV1.aircraftType"));
                isValid = false;
            }
            if (StringUtils.isEmpty((CharSequence)LambdaUtils.nullSafeApplyFunction(snt, sntV1 -> sntV1.getFillingOfAircraft().getFlightNumber()))) {
                this.addConstraintViolation(context, "fillingOfAircraft.flightNumber", this.generateNotNullFieldMessage("sntFillingOfAircraftV1.flightNumber"));
                isValid = false;
            }
            if (StringUtils.isEmpty((CharSequence)LambdaUtils.nullSafeApplyFunction(snt, sntV1 -> sntV1.getFillingOfAircraft().getWarrantNumber()))) {
                this.addConstraintViolation(context, "fillingOfAircraft.warrantNumber", this.generateNotNullFieldMessage("sntFillingOfAircraftV1.warrantNumber"));
                isValid = false;
            }
        }
        return isValid;
    }
}

