/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import javax.validation.ConstraintValidatorContext;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntGeneralProductCountCheckV1;

public class SntGeneralProductCountValidatorV1
extends AbstractClassLevelValidator<SntGeneralProductCountCheckV1, SntV1> {
    private static final Integer MAX_GENERAL_PRODUCT_COUNT = 200;

    public void initialize(SntGeneralProductCountCheckV1 constraintAnnotation) {
    }

    public boolean isValid(SntV1 value, ConstraintValidatorContext context) {
        int generalProductCount = 0;
        generalProductCount += LambdaUtils.nullSafeApplyFunction(value, snt -> snt.getProductSet().getProducts().size(), 0).intValue();
        generalProductCount += LambdaUtils.nullSafeApplyFunction(value, snt -> snt.getAlcoholSet().getAlcoholExceptBeerProductSet().getProducts().size(), 0).intValue();
        generalProductCount += LambdaUtils.nullSafeApplyFunction(value, snt -> snt.getAlcoholSet().getAlcoholBeerProductSet().getProducts().size(), 0).intValue();
        generalProductCount += LambdaUtils.nullSafeApplyFunction(value, snt -> snt.getAlcoholSet().getWineMaterialProductSet().getProducts().size(), 0).intValue();
        generalProductCount += LambdaUtils.nullSafeApplyFunction(value, snt -> snt.getAlcoholSet().getEthanolProductSet().getProducts().size(), 0).intValue();
        generalProductCount += LambdaUtils.nullSafeApplyFunction(value, snt -> snt.getOilSet().getProducts().size(), 0).intValue();
        generalProductCount += LambdaUtils.nullSafeApplyFunction(value, snt -> snt.getBiofuelSet().getProducts().size(), 0).intValue();
        generalProductCount += LambdaUtils.nullSafeApplyFunction(value, snt -> snt.getTobaccoSet().getProducts().size(), 0).intValue();
        generalProductCount += LambdaUtils.nullSafeApplyFunction(value, snt -> snt.getOtherProductWithDigitalMarkSet().getProducts().size(), 0).intValue();
        if ((generalProductCount += LambdaUtils.nullSafeApplyFunction(value, snt -> snt.getExportControlProductSet().getProducts().size(), 0).intValue()) == 0) {
            return this.setupContextWithValidationError(context, null, "{sntProduct.zeroCount}");
        }
        if (generalProductCount > MAX_GENERAL_PRODUCT_COUNT) {
            return this.setupContextWithValidationError(context, null, "{sntProduct.incorrectCount}");
        }
        return true;
    }
}

