/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.math.BigDecimal;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.version.v1.SntBaseProductV1;
import ru.uss.esf.validation.snt.version.v1.SntNdsAmountCheckV1;

public class SntNdsAmountValidatorV1
extends AbstractClassLevelValidator<SntNdsAmountCheckV1, SntBaseProductV1> {
    public void initialize(SntNdsAmountCheckV1 constraintAnnotation) {
    }

    public boolean isValid(SntBaseProductV1 sntProduct, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean result = true;
        Integer ndsRate = sntProduct.getNdsRate();
        BigDecimal ndsAmount = sntProduct.getNdsAmount();
        if ((ndsRate == null || ndsRate == 0) && ndsRate == null && ndsAmount != null && BigDecimal.ZERO.compareTo(ndsAmount) != 0) {
            context.buildConstraintViolationWithTemplate("{sntV1.products.ndsAmount.mustBeZero}").addPropertyNode("ndsAmount").addConstraintViolation();
            return false;
        }
        return result;
    }
}

