/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.utils.DateTimeUtils;
import ru.uss.core.utils.RegistrationNumberUtils;
import ru.uss.esf.model.snt.version.v1.SntBaseProductV1;
import ru.uss.esf.validation.snt.version.v1.SntProductNumberInDeclarationV2;

public class SntProductNumberInDeclarationValidatorV2
implements ConstraintValidator<SntProductNumberInDeclarationV2, SntBaseProductV1> {
    private static final Pattern PRODUCT_NUMBER_SHORT_PATTERN = Pattern.compile("^[0-9]{1,5}$");
    private static final Pattern PRODUCT_NUMBER_FULL_PATTERN = Pattern.compile("^[0-9]{1,5}(/[0-9]{1,5})?$");

    public void initialize(SntProductNumberInDeclarationV2 constraintAnnotation) {
    }

    public boolean isValid(SntBaseProductV1 product, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (StringUtils.isEmpty((CharSequence)product.getProductNumberInDeclaration())) {
            return true;
        }
        if (!StringUtils.isEmpty((CharSequence)product.getDeclarationNumberForSnt()) && (this.isValidDtNum(product.getDeclarationNumberForSnt()) || RegistrationNumberUtils.isSnt(product.getDeclarationNumberForSnt()))) {
            if (!PRODUCT_NUMBER_FULL_PATTERN.matcher(product.getProductNumberInDeclaration()).matches()) {
                context.buildConstraintViolationWithTemplate("{sntBaseProductV1.productNumberInDeclaration.withDT.wrongFormat}").addPropertyNode("productNumberInDeclaration").addConstraintViolation();
                return false;
            }
        } else if (!PRODUCT_NUMBER_SHORT_PATTERN.matcher(product.getProductNumberInDeclaration()).matches()) {
            context.buildConstraintViolationWithTemplate("{sntBaseProductV1.productNumberInDeclaration.withoutDT.wrongFormat}").addPropertyNode("productNumberInDeclaration").addConstraintViolation();
            return false;
        }
        return true;
    }

    private boolean isValidDtNum(String dtNum) {
        return dtNum != null && dtNum.length() == 20 && Pattern.matches("[0-9]{5}/[0-9]{6}/[012]{1}[0-9]{6}", dtNum) && DateTimeUtils.isDateValid(dtNum.substring(6, 12), "ddMMyy");
    }
}

