/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.BooleanUtils;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.version.v1.SntExportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntImportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntTransferTypeV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntSellerCountryCodeCheckV1;

public class SntSellerCountryCodeValidatorV1
extends AbstractClassLevelValidator<SntSellerCountryCodeCheckV1, SntV1> {
    public void initialize(SntSellerCountryCodeCheckV1 constraintAnnotation) {
    }

    public boolean isValid(SntV1 sntV1, ConstraintValidatorContext context) {
        if (sntV1.getSeller() == null) {
            return true;
        }
        SntImportTypeV1 sntImportType = LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSntImport().getImportType());
        SntExportTypeV1 sntExportType = LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSntExport().getExportType());
        Boolean sellerNonResident = BooleanUtils.isTrue((Boolean)LambdaUtils.nullSafeApplyFunction(sntV1, s -> s.getSeller().getNonResident()));
        if ((SntImportTypeV1.IMPORT_IN_SEZ.equals(sntImportType) && !sellerNonResident.booleanValue() || SntExportTypeV1.EXPORT_FROM_SEZ.equals(sntExportType)) && !"KZ".equals(sntV1.getSeller().getCountryCode())) {
            return this.setupContextWithValidationError(context, "seller.countryCode", "{sntParticipantV1.SEZ.countryCode.notKZ}");
        }
        if (sntV1.getSntImport() != null && sntV1.getTransferType() != SntTransferTypeV1.ONE_PERSON_IN_EAEU && BooleanUtils.isTrue((Boolean)sntV1.getSeller().getNonResident()) && "KZ".equals(sntV1.getSeller().getCountryCode())) {
            return this.setupContextWithValidationError(context, "seller.countryCode", "{sntSellerV1.countryCode.notKZ}");
        }
        if ((SntExportTypeV1.exportTypesWithoutSez().contains(sntExportType) || sntV1.getTransferType() == SntTransferTypeV1.ONE_PERSON_IN_KZ) && !"KZ".equals(sntV1.getSeller().getCountryCode())) {
            return this.setupContextWithValidationError(context, "seller.countryCode", "{sntSellerV1.countryCode.onlyKZ}");
        }
        return true;
    }
}

