/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.Objects;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntStoreCheckV1;

public class SntStoreValidatorV1
extends AbstractClassLevelValidator<SntStoreCheckV1, SntV1> {
    public void initialize(SntStoreCheckV1 constraintAnnotation) {
    }

    public boolean isValid(SntV1 snt, ConstraintValidatorContext context) {
        if (snt.getSeller() == null || snt.getCustomer() == null) {
            return true;
        }
        if (snt.getSellerStoreId() == null && snt.getCustomerStoreId() == null) {
            return true;
        }
        if (snt.getSellerStoreId() != null && snt.getSellerTin() == null) {
            return this.setupContextWithValidationError(context, "seller.storeId", "{SNT_STORE_ID_IS_NULL}");
        }
        if (snt.getCustomerStoreId() != null && snt.getCustomerTin() == null) {
            return this.setupContextWithValidationError(context, "customer.storeId", "{SNT_STORE_ID_IS_NULL}");
        }
        if (Objects.equals(snt.getSellerStoreId(), snt.getCustomerStoreId())) {
            return this.setupContextWithValidationError(context, "seller.storeId", "{sntV1.storeIds.equals}");
        }
        return true;
    }
}

