/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.model.dict;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import ru.uss.core.utils.DateTimeUtils;
import ru.uss.vstore.model.dict.EGsvsType;
import ru.uss.vstore.model.dict.Gsvs;

public class GsvsChain {
    private final List<Gsvs> gsvsList = new LinkedList<Gsvs>();

    public void addSortedGsvs(Gsvs gsvs) {
        this.gsvsList.add(gsvs);
    }

    public Gsvs findOnDate(Date date) {
        if (date == null) {
            return null;
        }
        for (Gsvs gsvs : this.gsvsList) {
            if (!DateTimeUtils.lessOrEquals(gsvs.getStartDate(), date) || gsvs.getEndDate() != null && !gsvs.getEndDate().after(date)) continue;
            return gsvs;
        }
        return null;
    }

    public List<Long> getFixedIdsByType(EGsvsType gsvsType) {
        return this.gsvsList.stream().filter(gsvs -> gsvsType.equals((Object)gsvs.getGsvsTypeCode())).map(Gsvs::getFixedId).collect(Collectors.toList());
    }

    public Gsvs getLast() {
        if (CollectionUtils.isEmpty(this.gsvsList)) {
            return null;
        }
        return this.gsvsList.get(this.gsvsList.size() - 1);
    }

    public Gsvs getLastStartDateLessOrEqualsOnDate(Date date) {
        Gsvs latestActiveGsvsBeforeDate = null;
        for (int i = this.gsvsList.size() - 1; i >= 0; --i) {
            Gsvs currentIterationGsvs = this.gsvsList.get(i);
            if (!DateTimeUtils.lessOrEquals(currentIterationGsvs.getStartDate(), date)) continue;
            latestActiveGsvsBeforeDate = currentIterationGsvs;
            break;
        }
        return latestActiveGsvsBeforeDate;
    }

    public Gsvs getLastLastActiveOnDate() {
        return this.gsvsList.size() > 1 ? this.gsvsList.get(this.gsvsList.size() - 2) : null;
    }
}

