/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.model.doc;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import ru.uss.core.adapter.DateAdapter;
import ru.uss.core.model.DocumentInfo;
import ru.uss.core.model.VersionedDocument;
import ru.uss.vstore.model.doc.DocumentProductFno;
import ru.uss.vstore.model.doc.ECustomsDutyType;
import ru.uss.vstore.model.doc.EDocumentStatusType;
import ru.uss.vstore.model.doc.FnoStatus;
import ru.uss.vstore.validation.fno.DocumentFnoRegistrationNumberCorrect;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DocumentFno")
@Documentation(value="\u0418\u0441\u0445\u043e\u0434\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0424\u041d\u041e")
public class DocumentFno
implements Serializable,
DocumentInfo,
VersionedDocument {
    public static final String VERSION = "FnoV1";
    public static final String PROCESSED_FNO_STATUS = "4";
    @XmlTransient
    @Documentation(value="ID")
    private Long id;
    @XmlElement
    @NotNull(message="{documentFno.fnoId.notNull}")
    @Documentation(value="ID \u0424\u041d\u041e \u0432\u043d\u0435\u0448\u043d\u0435\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u044b")
    private @NotNull(message="{documentFno.fnoId.notNull}") Long fnoId;
    @JsonIgnore
    @XmlElement
    @NotNull(message="{documentFno.fnoStatus.notNull}")
    @Documentation(value="\u0421\u0442\u0430\u0442\u0443\u0441 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u0424\u041d\u041e")
    private @NotNull(message="{documentFno.fnoStatus.notNull}") String fnoStatus;
    @NotNull(message="{documentFno.registrationNumber.notNull}")
    @XmlElement
    @Documentation(value="\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0437\u0430\u044f\u0432\u043b\u0435\u043d\u0438\u044f")
    @DocumentFnoRegistrationNumberCorrect
    private @NotNull(message="{documentFno.registrationNumber.notNull}") String registrationNumber;
    @NotNull(message="{documentFno.submitDate.notNull}")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    @XmlElement
    @Documentation(value="\u0414\u0430\u0442\u0430 \u043f\u043e\u0434\u0430\u0447\u0438 \u0437\u0430\u044f\u0432\u043b\u0435\u043d\u0438\u044f \u0432 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u043c \u0432\u0438\u0434\u0435")
    private @NotNull(message="{documentFno.submitDate.notNull}") Date submitDate;
    @XmlElement
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy HH:mm:ss")
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u043f\u043e\u0441\u0442\u0443\u043f\u043b\u0435\u043d\u0438\u044f")
    private Date inputDate;
    @XmlElement
    @Documentation(value="\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0437\u0430\u043c\u0435\u043d\u044f\u0435\u043c\u043e\u0433\u043e \u0437\u0430\u044f\u0432\u043b\u0435\u043d\u0438\u044f")
    @DocumentFnoRegistrationNumberCorrect(message="{documentFno.recallRegistrationNumber.incorrect}", propertyName="recallRegistrationNumber")
    private String recallRegistrationNumber;
    @XmlElement
    @Documentation(value="\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0437\u0430\u044f\u0432\u043b\u0435\u043d\u0438\u044f, \u043f\u043e\u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0432\u0437\u0430\u043c\u0435\u043d \u043e\u0442\u043e\u0437\u0432\u0430\u043d\u043d\u043e\u0433\u043e ")
    @DocumentFnoRegistrationNumberCorrect(message="{documentFno.dstRecallRegistrationNumber.incorrect}", propertyName="dstRecallRegistrationNumber")
    private String dstRecallRegistrationNumber;
    @XmlElement
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    @Documentation(value="\u0414\u0430\u0442\u0430 \u043f\u043e\u0434\u0430\u0447\u0438 \u0437\u0430\u044f\u0432\u043b\u0435\u043d\u0438\u044f \u043d\u0430 \u0431\u0443\u043c\u0430\u0436\u043d\u043e\u043c \u043d\u043e\u0441\u0438\u0442\u0435\u043b\u0435")
    private Date paperDate;
    @XmlElement
    @Documentation(value="\u041f\u0440\u0438\u0447\u0438\u043d\u0430 \u043e\u0442\u0437\u044b\u0432\u0430 \u0437\u0430\u044f\u0432\u043b\u0435\u043d\u0438\u044f \u043d\u0430 \u0440\u0443\u0441. \u044f\u0437.")
    private String spozName;
    @XmlElement
    @Documentation(value="\u041a\u043e\u0434 \u041d\u0423")
    private String cnoCode;
    @XmlElement
    @Documentation(value="\u041a\u043e\u0434 \u041d\u0414")
    private String cnoParentCode;
    @NotNull(message="{documentFno.sellerName.notNull}")
    @XmlElement
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0434\u0430\u0432\u0446\u0430")
    private @NotNull(message="{documentFno.sellerName.notNull}") String sellerName;
    @NotNull(message="{documentFno.sellerCountryCode.notNull}")
    @XmlElement
    @Documentation(value="\u041a\u043e\u0434 \u0441\u0442\u0440\u0430\u043d\u044b \u043f\u0440\u043e\u0434\u0430\u0432\u0446\u0430")
    private @NotNull(message="{documentFno.sellerCountryCode.notNull}") String sellerCountryCode;
    @NotNull(message="{documentFno.buyerId.notNull}")
    @XmlElement
    @Documentation(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0439 \u043a\u043e\u0434 (\u043d\u043e\u043c\u0435\u0440) \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f")
    private @NotNull(message="{documentFno.buyerId.notNull}") String buyerId;
    @XmlElement
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f \u0438\u0437 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 \u041d\u041f \u0418\u0421 \u042d\u0421\u0424")
    private String name;
    @NotNull(message="{documentFno.buyerName.notNull}")
    @XmlElement
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f \u0438\u0437 \u0424\u041d\u041e 328.00")
    private @NotNull(message="{documentFno.buyerName.notNull}") String buyerName;
    @NotNull(message="{documentFno.buyerCountryCode.notNull}")
    @XmlElement
    @Documentation(value="\u041a\u043e\u0434 \u0441\u0442\u0440\u0430\u043d\u044b \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f ")
    private @NotNull(message="{documentFno.buyerCountryCode.notNull}") String buyerCountryCode;
    @XmlElement
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u043e\u043d\u0435\u0440\u0430, \u043f\u043e\u0432\u0435\u0440\u0435\u043d\u043d\u043e\u0433\u043e, \u043b\u0438\u0431\u043e \u0430\u0433\u0435\u043d\u0442\u0430 1")
    private String consingeeName;
    @XmlElement
    @Documentation(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043b\u0438\u0437\u0438\u043d\u0433\u0430")
    private Boolean isLeasing;
    @XmlElement
    @Documentation(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043f\u0435\u0440\u0435\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0434\u0430\u0432\u0430\u043b\u044c\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0441\u044b\u0440\u044c\u044f ")
    private Boolean isProcessing;
    @Documentation(value="\u041a\u043e\u0434 \u0442\u0438\u043f\u0430 \u0422\u0430\u043c\u043e\u0436\u0435\u043d\u043d\u043e\u0439 \u043f\u043e\u0448\u043b\u0438\u043d\u044b")
    private ECustomsDutyType customsDutyTypeCode;
    @Valid
    @Size(min=1, message="{document.products.emptyList}")
    @NotNull(message="{document.products.emptyList}")
    @XmlElementWrapper
    @XmlElement(name="product", required=true)
    @Documentation(value="\u0422\u043e\u0432\u0430\u0440\u044b")
    private @Valid @Size(min=1, message="{document.products.emptyList}") @NotNull(message="{document.products.emptyList}") List<DocumentProductFno> products;
    @XmlTransient
    @Documentation(value="\u0421\u0442\u0430\u0442\u0443\u0441 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430")
    private EDocumentStatusType status;
    @Documentation(value="\u0412\u0435\u0440\u0441\u0438\u044f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430")
    private String version;
    @XmlElement
    @Documentation(value="\u041e\u0440\u0438\u0433\u0438\u043d\u0430\u043b\u044c\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 XML \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438")
    private String originalRequestXml;
    @XmlElement
    @Documentation(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0432\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u0438")
    private String messageId;
    @XmlTransient
    @Documentation(value="\u0424\u043b\u0430\u0433 \u043e\u043f\u0440\u0438\u0445\u043e\u0434\u043e\u0432\u0430\u043d\u0438\u044f \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u043d\u0430 \u0424\u041b-\u0441\u043a\u043b\u0430\u0434")
    private boolean isIndividual;
    @XmlTransient
    @Documentation(value="\u0424\u043b\u0430\u0433 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b \u0441\u043e\u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0441 \u0421\u041d\u0422")
    private boolean isMatchingDone;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getFnoId() {
        return this.fnoId;
    }

    public void setFnoId(Long fnoId) {
        this.fnoId = fnoId;
    }

    public String getFnoStatus() {
        return this.fnoStatus;
    }

    public void setFnoStatus(String fnoStatus) {
        this.fnoStatus = fnoStatus;
    }

    @Override
    public String getRegistrationNumber() {
        return this.registrationNumber;
    }

    public void setRegistrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
    }

    public Date getSubmitDate() {
        return this.submitDate;
    }

    public void setSubmitDate(Date submitDate) {
        this.submitDate = submitDate;
    }

    public Date getInputDate() {
        return this.inputDate;
    }

    public void setInputDate(Date inputDate) {
        this.inputDate = inputDate;
    }

    public String getRecallRegistrationNumber() {
        return this.recallRegistrationNumber;
    }

    public void setRecallRegistrationNumber(String recallRegistrationNumber) {
        this.recallRegistrationNumber = recallRegistrationNumber;
    }

    public String getDstRecallRegistrationNumber() {
        return this.dstRecallRegistrationNumber;
    }

    public void setDstRecallRegistrationNumber(String dstRecallRegistrationNumber) {
        this.dstRecallRegistrationNumber = dstRecallRegistrationNumber;
    }

    public Date getPaperDate() {
        return this.paperDate;
    }

    public void setPaperDate(Date paperDate) {
        this.paperDate = paperDate;
    }

    public String getSpozName() {
        return this.spozName;
    }

    public void setSpozName(String spozName) {
        this.spozName = spozName;
    }

    public String getCnoCode() {
        return this.cnoCode;
    }

    public void setCnoCode(String cnoCode) {
        this.cnoCode = cnoCode;
    }

    public String getCnoParentCode() {
        return this.cnoParentCode;
    }

    public void setCnoParentCode(String cnoParentCode) {
        this.cnoParentCode = cnoParentCode;
    }

    public String getSellerName() {
        return this.sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }

    public String getSellerCountryCode() {
        return this.sellerCountryCode;
    }

    public void setSellerCountryCode(String sellerCountryCode) {
        this.sellerCountryCode = sellerCountryCode;
    }

    public String getBuyerId() {
        return this.buyerId;
    }

    public void setBuyerId(String buyerId) {
        this.buyerId = buyerId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBuyerName() {
        return this.buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public String getBuyerCountryCode() {
        return this.buyerCountryCode;
    }

    public void setBuyerCountryCode(String buyerCountryCode) {
        this.buyerCountryCode = buyerCountryCode;
    }

    public String getConsingeeName() {
        return this.consingeeName;
    }

    public void setConsingeeName(String consingeeName) {
        this.consingeeName = consingeeName;
    }

    public Boolean getLeasing() {
        return this.isLeasing;
    }

    public void setLeasing(Boolean leasing) {
        this.isLeasing = leasing;
    }

    public Boolean getProcessing() {
        return this.isProcessing;
    }

    public void setProcessing(Boolean processing) {
        this.isProcessing = processing;
    }

    public ECustomsDutyType getCustomsDutyTypeCode() {
        return this.customsDutyTypeCode;
    }

    public void setCustomsDutyTypeCode(ECustomsDutyType customsDutyTypeCode) {
        this.customsDutyTypeCode = customsDutyTypeCode;
    }

    public List<DocumentProductFno> getProducts() {
        return this.products;
    }

    public void setProducts(List<DocumentProductFno> products) {
        this.products = products;
    }

    public EDocumentStatusType getStatus() {
        return this.status;
    }

    public void setStatus(EDocumentStatusType status) {
        this.status = status;
    }

    public String getOriginalRequestXml() {
        return this.originalRequestXml;
    }

    public void setOriginalRequestXml(String originalRequestXml) {
        this.originalRequestXml = originalRequestXml;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public boolean isIndividual() {
        return this.isIndividual;
    }

    public void setIndividual(boolean individual) {
        this.isIndividual = individual;
    }

    public boolean isMatchingDone() {
        return this.isMatchingDone;
    }

    public void setMatchingDone(boolean matchingDone) {
        this.isMatchingDone = matchingDone;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @XmlTransient
    @JsonProperty(value="fnoStatus", access=JsonProperty.Access.READ_ONLY)
    public FnoStatus fnoStatus() {
        return FnoStatus.parseCode(this.fnoStatus);
    }

    public String toString() {
        return "DocumentFno{id=" + this.id + ", fnoId=" + this.fnoId + ", fnoStatus='" + this.fnoStatus + '\'' + ", registrationNumber='" + this.registrationNumber + '\'' + ", submitDate=" + this.submitDate + ", recallRegistrationNumber='" + this.recallRegistrationNumber + '\'' + ", dstRecallRegistrationNumber='" + this.dstRecallRegistrationNumber + '\'' + ", paperDate=" + this.paperDate + ", spozName='" + this.spozName + '\'' + ", cnoCode='" + this.cnoCode + '\'' + ", cnoParentCode='" + this.cnoParentCode + '\'' + ", sellerName='" + this.sellerName + '\'' + ", sellerCountryCode='" + this.sellerCountryCode + '\'' + ", buyerId='" + this.buyerId + '\'' + ", buyerName='" + this.buyerName + '\'' + ", buyerCountryCode='" + this.buyerCountryCode + '\'' + ", consingeeName='" + this.consingeeName + '\'' + ", isLeasing=" + this.isLeasing + ", isProcessing=" + this.isProcessing + ", customsDutyTypeCode=" + (Object)((Object)this.customsDutyTypeCode) + ", products=" + this.products + ", status=" + (Object)((Object)this.status) + ", originalRequestXml='" + this.originalRequestXml + '\'' + ", messageId='" + this.messageId + '\'' + '}';
    }
}

