/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.model.doc;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.springframework.beans.BeanUtils;
import ru.uss.core.validation.common.RequiredString;
import ru.uss.vstore.model.doc.EQueueStatusType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DocumentProductGtd")
@Documentation(value="\u0422\u043e\u0432\u0430\u0440\u044b \u0438\u0437 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0413\u0422\u0414")
public class DocumentProductGtd
implements Serializable,
Cloneable {
    @XmlTransient
    @Documentation(value="ID")
    private Long id;
    @XmlElement
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438")
    private String rowNum;
    @RequiredString(required=false, minLen=1, maxLen=1024, fieldPath="productName")
    @XmlElement
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u043e\u0432\u0430\u0440\u0430")
    private String productName;
    @XmlElement
    @Documentation(value="\u0415\u0434\u0438\u043d\u0438\u0446\u0430 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f")
    private String measureUnitCode;
    @NotNull(message="{documentProduct.quantity.notNull}")
    @XmlElement
    @Documentation(value="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e")
    private @NotNull(message="{documentProduct.quantity.notNull}") BigDecimal quantity;
    @RequiredString(required=false, minLen=1, maxLen=32, fieldPath="tnvedCode")
    @XmlElement
    @Documentation(value="\u041a\u043e\u0434 \u0422\u041d \u0412\u042d\u0414")
    private String tnvedCode;
    @XmlTransient
    @Documentation(value="\u0415\u0434. \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f \u043d\u0430 \u0440\u0443\u0441\u0441\u043a\u043e\u043c \u044f\u0437\u044b\u043a\u0435")
    private String measureUnitNameRu;
    @XmlTransient
    @Documentation(value="\u0415\u0434. \u0438\u0437\u043c \u043d\u0430 \u043a\u0430\u0437\u0430\u0445\u0441\u043a\u043e\u043c \u044f\u0437\u044b\u043a\u0435")
    private String measureUnitNameKz;
    @XmlElement
    @Documentation(value="\u0426\u0435\u043d\u0430 \u0442\u043e\u0432\u0430\u0440\u0430")
    private BigDecimal invoicedCost;
    @XmlElement
    @Documentation(value="\u0422\u0430\u043c\u043e\u0436\u0435\u043d\u043d\u0430\u044f \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c")
    private BigDecimal customsCost;
    @XmlElement
    @Documentation(value="\u0412\u043e\u0437\u043c\u043e\u0436\u0435\u043d \u044d\u043a\u0441\u043f\u043e\u0440\u0442")
    private boolean canExport;
    @RequiredString(required=false, minLen=1, maxLen=200, fieldPath="serialNumber")
    @XmlElement
    @Documentation(value="\u0421\u0435\u0440\u0438\u0439\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440")
    private String serialNumber;
    @RequiredString(required=false, minLen=1, maxLen=9, fieldPath="exciseSerieses")
    @XmlElement
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u0441\u0435\u0440\u0438\u0438 \u0430\u043a\u0446\u0438\u0437\u043d\u044b\u0445 \u043c\u0430\u0440\u043e\u043a")
    private String exciseSerieses;
    @XmlElement
    @Documentation(value="\u041f\u0435\u0440\u0432\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 \u043d\u043e\u043c\u0435\u0440\u043e\u0432 \u0430\u043a\u0446\u0438\u0437\u043d\u044b\u0445 \u043c\u0430\u0440\u043e\u043a")
    private BigDecimal exciseFirstNumber;
    @XmlElement
    @Documentation(value="\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u043d\u043e\u043c\u0435\u0440 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 \u043d\u043e\u043c\u0435\u0440\u043e\u0432 \u0430\u043a\u0446\u0438\u0437\u043d\u044b\u0445 \u043c\u0430\u0440\u043e\u043a")
    private BigDecimal exciseLastNumber;
    @XmlElement
    @Documentation(value="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0430\u043a\u0446\u0438\u0437\u043d\u044b\u0445 \u043c\u0430\u0440\u043e\u043a")
    private BigInteger exciseQuantity;
    @RequiredString(required=false, minLen=1, maxLen=40, fieldPath="vinid")
    @XmlElement
    @Documentation(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 (VIN)")
    private String vinid;
    @XmlTransient
    @Documentation(value="\u0421\u0442\u0430\u0442\u0443\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0442\u043e\u0432\u0430\u0440\u0430")
    private EQueueStatusType status;
    @XmlTransient
    @Documentation(value="\u0414\u0430\u0442\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0442\u043e\u0432\u0430\u0440\u0430")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    private Date processingDate;
    @RequiredString(required=false, minLen=1, maxLen=2, fieldPath="mainCustomsModeCode")
    @XmlElement
    @Documentation(value="\u041a\u043e\u0434 \u0437\u0430\u044f\u0432\u043b\u044f\u0435\u043c\u043e\u0439 \u0442\u0430\u043c\u043e\u0436\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b")
    private String mainCustomsModeCode;
    @RequiredString(required=false, minLen=1, maxLen=2, fieldPath="precedingCustomsModeCode")
    @XmlElement
    @Documentation(value="\u041a\u043e\u0434 \u043f\u0440\u0435\u0434\u0448\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0439 \u0442\u0430\u043c\u043e\u0436\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b")
    private String precedingCustomsModeCode;
    @XmlElement
    @Documentation(value="\u0424\u043b\u0430\u0433 \u0434\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0438\u043c\u043f\u043e\u0440\u0442\u0430")
    private Boolean hasImportDetailing;
    @XmlElement
    @Documentation(value="\u0414\u0422, \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0449\u0438\u0439 \u0442\u043e\u0432\u0430\u0440 \u0432 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0435, \u0440\u0430\u0432\u043d\u043e\u043c \u0431\u043e\u043b\u0435\u0435 1, \u043d\u043e \u0437\u0430\u0434\u0435\u043a\u043b\u0430\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u043a\u0430\u043a \u043e\u0434\u0438\u043d \u0442\u043e\u0432\u0430\u0440")
    private Boolean splittedGoods;
    @XmlTransient
    @Documentation(value="\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0438\u0439 \u043f\u043e\u0440\u044f\u0434\u043a\u043e\u0432\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0442\u043e\u0432\u0430\u0440\u043d\u043e\u0439 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 \u0432 \u0434\u0435\u043a\u043b\u0430\u0440\u0430\u0446\u0438\u0438")
    private String innerRowIndex;
    @XmlElement
    @Documentation(value="\u041f\u0440\u0435\u0434\u0448\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b. \u0413\u0440. 40")
    private Set<String> precedingDocumentNumbers = new HashSet<String>();
    @XmlTransient
    @Documentation(value="\u0421\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432")
    private Set<String> presentedDocumentNumbers = new HashSet<String>();
    @XmlTransient
    @Documentation(value="\u0421\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0439 \u0417\u0412\u0422-\u043d\u043e\u043c\u0435\u0440")
    private String zvtRegNum;

    public DocumentProductGtd(DocumentProductGtd documentProductGtd) {
        BeanUtils.copyProperties((Object)documentProductGtd, (Object)this);
    }

    public DocumentProductGtd() {
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRowNum() {
        return this.rowNum;
    }

    public void setRowNum(String rowNum) {
        this.rowNum = rowNum;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getMeasureUnitCode() {
        return this.measureUnitCode;
    }

    public void setMeasureUnitCode(String measureUnitCode) {
        this.measureUnitCode = measureUnitCode;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public String getTnvedCode() {
        return this.tnvedCode;
    }

    public void setTnvedCode(String tnvedCode) {
        this.tnvedCode = tnvedCode;
    }

    public String getMeasureUnitNameRu() {
        return this.measureUnitNameRu;
    }

    public void setMeasureUnitNameRu(String measureUnitNameRu) {
        this.measureUnitNameRu = measureUnitNameRu;
    }

    public String getMeasureUnitNameKz() {
        return this.measureUnitNameKz;
    }

    public void setMeasureUnitNameKz(String measureUnitNameKz) {
        this.measureUnitNameKz = measureUnitNameKz;
    }

    public BigDecimal getInvoicedCost() {
        return this.invoicedCost;
    }

    public void setInvoicedCost(BigDecimal invoicedCost) {
        this.invoicedCost = invoicedCost;
    }

    public BigDecimal getCustomsCost() {
        return this.customsCost;
    }

    public void setCustomsCost(BigDecimal customsCost) {
        this.customsCost = customsCost;
    }

    public boolean isCanExport() {
        return this.canExport;
    }

    public void setCanExport(boolean canExport) {
        this.canExport = canExport;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getExciseSerieses() {
        return this.exciseSerieses;
    }

    public void setExciseSerieses(String exciseSerieses) {
        this.exciseSerieses = exciseSerieses;
    }

    public BigDecimal getExciseFirstNumber() {
        return this.exciseFirstNumber;
    }

    public void setExciseFirstNumber(BigDecimal exciseFirstNumber) {
        this.exciseFirstNumber = exciseFirstNumber;
    }

    public BigDecimal getExciseLastNumber() {
        return this.exciseLastNumber;
    }

    public void setExciseLastNumber(BigDecimal exciseLastNumber) {
        this.exciseLastNumber = exciseLastNumber;
    }

    public BigInteger getExciseQuantity() {
        return this.exciseQuantity;
    }

    public void setExciseQuantity(BigInteger exciseQuantity) {
        this.exciseQuantity = exciseQuantity;
    }

    public String getVinid() {
        return this.vinid;
    }

    public void setVinid(String vinid) {
        this.vinid = vinid;
    }

    public EQueueStatusType getStatus() {
        return this.status;
    }

    public void setStatus(EQueueStatusType status) {
        this.status = status;
    }

    public Date getProcessingDate() {
        return this.processingDate;
    }

    public void setProcessingDate(Date processingDate) {
        this.processingDate = processingDate;
    }

    public String getMainCustomsModeCode() {
        return this.mainCustomsModeCode;
    }

    public void setMainCustomsModeCode(String mainCustomsModeCode) {
        this.mainCustomsModeCode = mainCustomsModeCode;
    }

    public String getPrecedingCustomsModeCode() {
        return this.precedingCustomsModeCode;
    }

    public void setPrecedingCustomsModeCode(String precedingCustomsModeCode) {
        this.precedingCustomsModeCode = precedingCustomsModeCode;
    }

    public Boolean getHasImportDetailing() {
        return this.hasImportDetailing;
    }

    public void setHasImportDetailing(Boolean hasImportDetailing) {
        this.hasImportDetailing = hasImportDetailing;
    }

    public Set<String> getPrecedingDocumentNumbers() {
        return this.precedingDocumentNumbers;
    }

    public void setPrecedingDocumentNumbers(Set<String> precedingDocumentNumbers) {
        this.precedingDocumentNumbers = precedingDocumentNumbers;
    }

    public Boolean getSplittedGoods() {
        return this.splittedGoods;
    }

    public String getInnerRowIndex() {
        return this.innerRowIndex;
    }

    public void setInnerRowIndex(String innerRowIndex) {
        this.innerRowIndex = innerRowIndex;
    }

    public void setSplittedGoods(Boolean splittedGoods) {
        this.splittedGoods = splittedGoods;
    }

    public Set<String> getPresentedDocumentNumbers() {
        return this.presentedDocumentNumbers;
    }

    public void setPresentedDocumentNumbers(Set<String> presentedDocumentNumbers) {
        this.presentedDocumentNumbers = presentedDocumentNumbers;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public BigDecimal calculatePriceFromCustomsCost(BigDecimal quantity, int scale, RoundingMode roundingMode) {
        BigDecimal price = BigDecimal.ONE;
        if (this.customsCost != null && quantity != null && BigDecimal.ZERO.compareTo(quantity) != 0) {
            price = this.customsCost.divide(quantity, scale, roundingMode);
        }
        return price;
    }

    public BigDecimal calculatePriceFromCustomsCost(BigDecimal quantity) {
        return this.calculatePriceFromCustomsCost(quantity, 2, RoundingMode.HALF_UP);
    }

    public BigDecimal calculatePriceFromCustomsCost() {
        return this.calculatePriceFromCustomsCost(this.quantity, 2, RoundingMode.HALF_UP);
    }

    public String getRowNumPart1() {
        return this.rowNum == null || this.rowNum.length() == 0 ? null : this.rowNum.split("/")[0];
    }
}

