/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.model.uform.abstractuform;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Digits;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import ru.uss.core.adapter.DateAdapter;
import ru.uss.core.model.VersionedDocument;
import ru.uss.core.validation.common.IsNotNull;
import ru.uss.core.validation.common.IsNull;
import ru.uss.core.validation.common.PastDate;
import ru.uss.esf.validation.common.field.Text;
import ru.uss.vstore.model.doc.EUFormDetailingType;
import ru.uss.vstore.model.doc.EUFormType;
import ru.uss.vstore.model.doc.UFormWriteOffType;
import ru.uss.vstore.model.uform.abstractuform.AbstractUFormProduct;
import ru.uss.vstore.model.uform.abstractuform.UFormRecipient;
import ru.uss.vstore.model.uform.abstractuform.UFormSender;
import ru.uss.vstore.model.uform.version.v1.UFormV1;
import ru.uss.vstore.validation.uform.UFormTypes;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
@JsonSubTypes(value={@JsonSubTypes.Type(value=UFormV1.class)})
@XmlRootElement(name="uForm")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AbstractUForm")
@Documentation(value="\u0411\u0430\u0437\u043e\u0432\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e\u0431 \u0423\u043d\u0438\u0432\u0435\u0440\u0441\u0430\u043b\u044c\u043d\u043e\u0439 \u0424\u043e\u0440\u043c\u0435 \u0434\u043b\u044f \u0432\u0441\u0435\u0445 \u0432\u0435\u0440\u0441\u0438\u0439 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0412\u0421")
@JsonIgnoreProperties(value={"@class"})
public abstract class AbstractUForm
implements Serializable,
VersionedDocument {
    @XmlTransient
    @JsonIgnore
    @Documentation(value="ID")
    private Long id;
    @Text(min=1, max=30, message="{uForm.number.size}")
    @IsNotNull(message="{uForm.number.notNull}")
    @XmlElement(required=true)
    @Documentation(value="\u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u043d\u043e\u043c\u0435\u0440 \u0423\u043d\u0438\u0432\u0435\u0440\u0441\u0430\u043b\u044c\u043d\u043e\u0439 \u0424\u043e\u0440\u043c\u044b \u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0438\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044f")
    private String number;
    @IsNotNull(message="{uForm.date.notNull}")
    @PastDate(fieldPath="uForm.date")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0432\u044b\u043f\u0438\u0441\u043a\u0438 \u0423\u043d\u0438\u0432\u0435\u0440\u0441\u0430\u043b\u044c\u043d\u043e\u0439 \u0424\u043e\u0440\u043c\u044b")
    private Date date;
    @IsNotNull.List(value={@IsNotNull(fieldPath="uForm.sender", groups={UFormTypes.Balance.class, UFormTypes.BalanceCorrection.class, UFormTypes.Movement.class}), @IsNotNull(message="{uForm.manufacturer.notNull}", groups={UFormTypes.Manufacture.class}), @IsNotNull(message="{uForm.owner.notNull}", groups={UFormTypes.WriteOff.class, UFormTypes.Detailing.class, UFormTypes.PhysicalLabel.class, UFormTypes.Reorganization.class})})
    @Valid
    @XmlElement
    @Documentation(value="\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044c/\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044c")
    private UFormSender sender;
    @IsNotNull(fieldPath="uForm.recipient", groups={UFormTypes.Movement.class, UFormTypes.Reorganization.class, UFormTypes.PhysicalLabel.class})
    @IsNull(fieldPath="uForm.recipient", groups={UFormTypes.Balance.class, UFormTypes.BalanceCorrection.class, UFormTypes.Manufacture.class, UFormTypes.WriteOff.class, UFormTypes.Detailing.class})
    @Valid
    @XmlElement
    @Documentation(value="\u041f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044c")
    private UFormRecipient recipient;
    @IsNotNull(message="{uForm.type.notNull}")
    @XmlElement(required=true)
    @Documentation(value="\u041a\u043e\u0434 \u0442\u0438\u043f\u0430 \u0423\u043d\u0438\u0432\u0435\u0440\u0441\u0430\u043b\u044c\u043d\u043e\u0439 \u0424\u043e\u0440\u043c\u044b")
    private EUFormType type;
    @IsNotNull(fieldPath="uForm.totalSum", groups={UFormTypes.Balance.class, UFormTypes.BalanceCorrection.class, UFormTypes.Manufacture.class, UFormTypes.Movement.class, UFormTypes.Detailing.class, UFormTypes.PhysicalLabel.class, UFormTypes.WriteOff.class})
    @IsNull(fieldPath="uForm.totalSum", groups={UFormTypes.Reorganization.class})
    @Digits(integer=15, fraction=2, message="{uForm.totalSum.digits}")
    @XmlElement
    @Documentation(value="\u041e\u0431\u0449\u0430\u044f \u0441\u0443\u043c\u043c\u0430")
    private @Digits(integer=15, fraction=2, message="{uForm.totalSum.digits}") BigDecimal totalSum;

    public abstract <T extends AbstractUFormProduct> List<T> getProducts();

    public abstract <T extends AbstractUFormProduct> List<T> getSourceProducts();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public EUFormType getType() {
        return this.type;
    }

    public void setType(EUFormType type) {
        this.type = type;
    }

    public BigDecimal getTotalSum() {
        return this.totalSum;
    }

    public void setTotalSum(BigDecimal totalSum) {
        this.totalSum = totalSum;
    }

    public Long getRecipientStoreId() {
        if (this.recipient != null) {
            return this.recipient.getStoreId();
        }
        return null;
    }

    public Long getSenderStoreId() {
        if (this.sender != null) {
            return this.sender.getStoreId();
        }
        return null;
    }

    public String getSenderTin() {
        if (this.sender != null) {
            return this.sender.getTin();
        }
        return null;
    }

    public String getRecipientTin() {
        if (this.recipient != null) {
            return this.recipient.getTin();
        }
        return null;
    }

    public Long getSenderProjectCode() {
        if (this.sender != null) {
            return this.sender.getProjectCode();
        }
        return null;
    }

    public Long getRecipientProjectCode() {
        if (this.recipient != null) {
            return this.recipient.getProjectCode();
        }
        return null;
    }

    public UFormSender getSender() {
        return this.sender;
    }

    public void setSender(UFormSender sender) {
        this.sender = sender;
    }

    public UFormRecipient getRecipient() {
        return this.recipient;
    }

    public void setRecipient(UFormRecipient recipient) {
        this.recipient = recipient;
    }

    public abstract EUFormDetailingType getDetailingType();

    public abstract UFormWriteOffType getWriteOffReason();
}

