/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.validation.fno;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.utils.DateTimeUtils;
import ru.uss.vstore.validation.fno.DocumentFnoRegistrationNumberCorrect;

public class DocumentFnoRegistrationNumberCorrectValidator
implements ConstraintValidator<DocumentFnoRegistrationNumberCorrect, String> {
    private String defaultMessage;
    private String propertyName = "";

    public void initialize(DocumentFnoRegistrationNumberCorrect documentFnoRegistrationNumberCorrect) {
        this.defaultMessage = documentFnoRegistrationNumberCorrect.message();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null || value.isEmpty()) {
            return true;
        }
        if (value.length() != 18) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(this.defaultMessage).addPropertyNode(this.propertyName).addConstraintViolation();
            return false;
        }
        Pattern p = Pattern.compile("^[0-9]{12}[NI][0-9]{5}$");
        Matcher m = p.matcher(value);
        boolean isValid = true;
        if (!m.matches()) {
            isValid = false;
        } else {
            String sDate = value.substring(4, 12);
            if (!DateTimeUtils.isDateValid(sDate, "ddMMyyyy")) {
                isValid = false;
            }
        }
        if (!isValid) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(this.defaultMessage).addPropertyNode(this.propertyName).addConstraintViolation();
            return false;
        }
        return true;
    }
}

