/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.validation.uform;

import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.BooleanUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.vstore.model.uform.version.v1.UFormProductV1;
import ru.uss.vstore.model.uform.version.v1.UFormV1;
import ru.uss.vstore.validation.uform.UFormDetailingProductListSizeV1;

public class UFormDetailingProductListSizeValidatorV1
extends AbstractClassLevelValidator<UFormDetailingProductListSizeV1, UFormV1> {
    public UFormDetailingProductListSizeValidatorV1() {
        super("detailingType");
    }

    public void initialize(UFormDetailingProductListSizeV1 uFormDetailingProductListSizeV1) {
    }

    public boolean isValid(UFormV1 uFormV1, ConstraintValidatorContext context) {
        if (uFormV1.getProducts() == null || uFormV1.getSourceProducts() == null || uFormV1.getDetailingType() == null) {
            return true;
        }
        switch (uFormV1.getDetailingType()) {
            case RE_SORTING: {
                return this.isSizeOne(uFormV1.getSourceProducts(), "sourceProducts", context) && this.isSizeOne(uFormV1.getProducts(), "products", context);
            }
            case UNPACKING: {
                return this.isSizeOne(uFormV1.getSourceProducts(), "sourceProducts", context) && this.isSizeGreaterThanOne(uFormV1.getProducts(), "products", context);
            }
            case PACKING: {
                return (BooleanUtils.isTrue((Boolean)uFormV1.getTransformation()) && this.isSizeOne(uFormV1.getSourceProducts(), "products", context) || this.isSizeGreaterThanOne(uFormV1.getSourceProducts(), "sourceProducts", context)) && this.isSizeOne(uFormV1.getProducts(), "products", context);
            }
            case CONVERSION: 
            case EDITING: {
                return this.isSizeEqual(uFormV1.getSourceProducts(), uFormV1.getProducts(), context);
            }
        }
        return true;
    }

    private boolean isSizeOne(List<UFormProductV1> list, String property, ConstraintValidatorContext context) {
        if (list.size() != 1) {
            return this.setupContextWithValidationError(context, "{uForm." + property + ".size}");
        }
        return true;
    }

    private boolean isSizeGreaterThanOne(List<UFormProductV1> list, String property, ConstraintValidatorContext context) {
        if (list.size() <= 1) {
            return this.setupContextWithValidationError(context, "{uForm." + property + ".size}");
        }
        return true;
    }

    private boolean isSizeEqual(List<UFormProductV1> source, List<UFormProductV1> list, ConstraintValidatorContext context) {
        if (source.size() != list.size()) {
            return this.setupContextWithValidationError(context, "{uForm." + (source.size() < list.size() ? "sourceProducts" : "products") + ".size}");
        }
        return true;
    }
}

