/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.validation.uform;

import java.math.BigDecimal;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.vstore.model.uform.version.v1.UFormProductV1;
import ru.uss.vstore.model.uform.version.v1.UFormV1;
import ru.uss.vstore.validation.uform.UFormProductsSumCheckV1;

public class UFormProductsSumValidatorV1
extends AbstractClassLevelValidator<UFormProductsSumCheckV1, UFormV1> {
    public void initialize(UFormProductsSumCheckV1 constraintAnnotation) {
    }

    public boolean isValid(UFormV1 uFormV1, ConstraintValidatorContext context) {
        if (uFormV1 == null) {
            return true;
        }
        boolean valid = true;
        if (!CollectionUtils.isEmpty(uFormV1.getProducts())) {
            valid = this.validateProductSum(uFormV1.getProducts(), "products", context);
        }
        if (!CollectionUtils.isEmpty(uFormV1.getSourceProducts())) {
            valid = this.validateProductSum(uFormV1.getSourceProducts(), "sourceProducts", context);
        }
        return valid;
    }

    private boolean validateProductSum(List<UFormProductV1> uFormProductsV1, String property, ConstraintValidatorContext context) {
        boolean validationResult = true;
        for (int i = 0; i < uFormProductsV1.size(); ++i) {
            UFormProductV1 productV1 = uFormProductsV1.get(i);
            String fieldPath = String.format("%s[%d].sum", property, i);
            if (productV1.getSum() == null) continue;
            if (productV1.getSum().compareTo(BigDecimal.ZERO) < 0) {
                validationResult = false;
                this.setupContextWithValidationError(context, fieldPath, "\u0421\u0443\u043c\u043c\u0430 {positive}");
                continue;
            }
            if (productV1.getPrice() == null || productV1.getQuantity() == null) continue;
            BigDecimal errorSum = BigDecimal.ZERO;
            BigDecimal productSumEdited = productV1.getSum();
            BigDecimal productSum = productV1.getPrice().multiply(productV1.getQuantity());
            if (productSum.compareTo(productSumEdited) < 0) {
                errorSum = productSumEdited.subtract(productSum);
            } else if (productSum.compareTo(productSumEdited) > 0) {
                errorSum = productSum.subtract(productSumEdited);
            }
            if (errorSum.compareTo(new BigDecimal(200)) <= 0) continue;
            validationResult = false;
            this.setupContextWithValidationError(context, fieldPath, "{uForm.products.permissibleError}");
        }
        return validationResult;
    }
}

