/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.validation.uformproduct.version.v1;

import java.util.Arrays;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.utils.RegistrationNumberUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.vstore.model.doc.ECustomsDutyType;
import ru.uss.vstore.model.uform.version.v1.UFormProductV1;
import ru.uss.vstore.validation.uformproduct.version.v1.UFormProductDutyTypeCodeV1;

public class UFormProductDutyTypeCodeValidatorV1
extends AbstractClassLevelValidator<UFormProductDutyTypeCodeV1, UFormProductV1> {
    private static final List<String> _345 = Arrays.asList("3", "4", "5");
    private static final List<ECustomsDutyType> INSTALLED_DUTY_TYPE_CODES = Arrays.asList(ECustomsDutyType.CCT, ECustomsDutyType.WTO, ECustomsDutyType.EAEU);

    public UFormProductDutyTypeCodeValidatorV1() {
        super("dutyTypeCode");
    }

    public void initialize(UFormProductDutyTypeCodeV1 constraintAnnotation) {
    }

    public boolean isValid(UFormProductV1 productV1, ConstraintValidatorContext context) {
        String originCode = productV1.getOriginCode();
        if (StringUtils.isBlank((CharSequence)originCode)) {
            return true;
        }
        if (productV1.getDutyTypeCode() == null) {
            return this.setupContextWithValidationError(context, this.generateNotNullFieldMessage("uFormProduct.dutyTypeCode"));
        }
        ECustomsDutyType dutyTypeCode = productV1.getDutyTypeCode();
        if ("1".equals(originCode) || "2".equals(originCode) ? !RegistrationNumberUtils.isZvt(productV1.getManufactureOrImportDocNumber()) && !INSTALLED_DUTY_TYPE_CODES.contains((Object)dutyTypeCode) : _345.contains(originCode) && dutyTypeCode != ECustomsDutyType.NOT_INSTALLED) {
            return this.setupContextWithValidationError(context, "{uFormProduct.dutyTypeCode.invalid}");
        }
        return true;
    }
}

