/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.provider.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.kalkan.asn1.ASN1Encodable;
import kz.gov.pki.kalkan.asn1.DEREncodable;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DERSet;
import kz.gov.pki.kalkan.asn1.cryptopro.CryptoProObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.knca.KNCAObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x509.KeyPurposeId;
import kz.gov.pki.kalkan.asn1.x509.KeyStoreInfo;
import kz.gov.pki.kalkan.asn1.x509.X509ExtensionsGenerator;
import kz.gov.pki.kalkan.asn1.x509.X509Name;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.kalkan.exception.PCSCCode;
import kz.gov.pki.kalkan.pcsc.Smartcard;
import kz.gov.pki.kalkan.pcsc.TokenDispatcher;
import kz.gov.pki.kalkan.pcsc.generators.AKAlgorithmParameterSpec;
import kz.gov.pki.kalkan.pcsc.tokens.AKToken;
import kz.gov.pki.kalkan.util.KALKANUtils;
import kz.gov.pki.kalkan.util.encoders.Hex;
import kz.gov.pki.kalkan.util.io.Streams;
import kz.gov.pki.kalkan.x509.X509Attribute;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.exception.ProviderUtilExceptionCode;
import kz.gov.pki.provider.utils.CSRUtil;
import kz.gov.pki.provider.utils.PKIXUtil;
import kz.gov.pki.provider.utils.X509Util;
import kz.gov.pki.provider.utils.model.SigningEntity;
import kz.gov.pki.reference.KNCACertificateType;
import kz.gov.pki.reference.KeyStoreEntry;
import kz.gov.pki.reference.PublicPartInfo;

public class KeyStoreUtil {
    private static final String CA_CERTS_STORE = "/cacerts.jks";
    private static final String KZTKN_PREFIX = "DigiFlow LLP. KAZTOKEN";
    private static final String P12_EXTENSION = "p12";
    private static final String JKS_EXTENSION = "jks";
    private static final String DOT = ".";
    private static List<X509Certificate> defaultCACerts;
    private static final Set<String> SIGNATURE_ALGORITHM_IDS;

    public static List<String> loadSlotList(Storage specifiedStorage) throws CardException, ProviderUtilException, KalkanException {
        if (!specifiedStorage.isToken()) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.UNKNOWN_STORAGE_FOR_THE_CURRENT_OPERATION);
        }
        ArrayList<String> slotList = new ArrayList<String>();
        try {
            KeyStoreUtil.establishNewContext();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TerminalFactory factory = TerminalFactory.getDefault();
        List<CardTerminal> lReaders = factory.terminals().list();
        block10: for (CardTerminal terminal : lReaders) {
            String tName = terminal.getName();
            System.out.println(tName + " = isPresent = " + terminal.isCardPresent());
            if (!terminal.isCardPresent()) continue;
            switch (specifiedStorage) {
                case KAZTOKEN: {
                    if (!KeyStoreUtil.isSpecifiedToken(tName, specifiedStorage)) continue block10;
                    slotList.add(tName);
                    continue block10;
                }
                case KZIDCARD: {
                    if (tName.startsWith(KZTKN_PREFIX) || !KeyStoreUtil.isSpecifiedToken(tName, specifiedStorage) || KeyStoreUtil.getPublicPartInfo(specifiedStorage, tName, PublicPartInfo.IIN) == null) continue block10;
                    slotList.add(tName);
                    continue block10;
                }
                case ETOKEN_72K: {
                    if (tName.startsWith(KZTKN_PREFIX) || !KeyStoreUtil.isSpecifiedToken(tName, specifiedStorage)) continue block10;
                    slotList.add(tName);
                    continue block10;
                }
                case JACARTA: {
                    if (tName.startsWith(KZTKN_PREFIX) || !KeyStoreUtil.isSpecifiedToken(tName, specifiedStorage)) continue block10;
                    slotList.add(tName);
                    continue block10;
                }
                case AKEY: {
                    if (tName.startsWith(KZTKN_PREFIX) || !KeyStoreUtil.isSpecifiedToken(tName, specifiedStorage)) continue block10;
                    slotList.add(tName);
                    continue block10;
                }
                case ETOKEN_5110: {
                    if (tName.startsWith(KZTKN_PREFIX) || !KeyStoreUtil.isSpecifiedToken(tName, specifiedStorage)) continue block10;
                    slotList.add(tName);
                    continue block10;
                }
            }
            throw new ProviderUtilException(ProviderUtilExceptionCode.UNKNOWN_STORAGE, "Smartcard type is unknown!");
        }
        return slotList;
    }

    private static void establishNewContext() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        String osname = System.getProperty("os.name").toLowerCase();
        if (osname.contains("windows")) {
            Class<?> pcscterminal = Class.forName("sun.security.smartcardio.PCSCTerminals");
            Field contextId = pcscterminal.getDeclaredField("contextId");
            contextId.setAccessible(true);
            if (contextId.getLong(pcscterminal) != 0L) {
                Class<?> pcsc = Class.forName("sun.security.smartcardio.PCSC");
                Method SCardEstablishContext = pcsc.getDeclaredMethod("SCardEstablishContext", Integer.TYPE);
                SCardEstablishContext.setAccessible(true);
                Field SCARD_SCOPE_USER = pcsc.getDeclaredField("SCARD_SCOPE_USER");
                SCARD_SCOPE_USER.setAccessible(true);
                long newId = (Long)SCardEstablishContext.invoke(pcsc, SCARD_SCOPE_USER.getInt(pcsc));
                contextId.setLong(pcscterminal, newId);
                TerminalFactory factory = TerminalFactory.getDefault();
                CardTerminals terminals = factory.terminals();
                Field fieldTerminals = pcscterminal.getDeclaredField("terminals");
                fieldTerminals.setAccessible(true);
                Class<?> classMap = Class.forName("java.util.Map");
                Method clearMap = classMap.getDeclaredMethod("clear", new Class[0]);
                clearMap.invoke(fieldTerminals.get(terminals), new Object[0]);
                Field fieldStateMap = pcscterminal.getDeclaredField("stateMap");
                fieldStateMap.setAccessible(true);
                Object fieldStateMapObj = fieldStateMap.get(terminals);
                if (fieldStateMapObj != null) {
                    clearMap.invoke(fieldStateMapObj, new Object[0]);
                }
            }
        }
    }

    public static String getPublicPartInfo(Storage storage, String tName, PublicPartInfo info) throws ProviderUtilException, KalkanException {
        if (!storage.equals((Object)Storage.KZIDCARD)) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.UNKNOWN_STORAGE_FOR_THE_CURRENT_OPERATION);
        }
        AKToken token = TokenDispatcher.INSTANCE.instantiateToken(Storage.KZIDCARD.getName(), tName, null);
        String result = token.getPublicPartInfo(info.name());
        TokenDispatcher.INSTANCE.removeToken(token);
        return result;
    }

    public static KeyStore getKeyStore(Storage storage, String container, char[] password, Provider provider) throws KeyStoreException, NoSuchProviderException, ProviderUtilException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore store = KeyStore.getInstance(storage.getName(), provider.getName());
        try {
            KeyStoreUtil.loadKeyStore(storage, container, store, password);
        }
        catch (IOException e) {
            String msg = "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c.";
            if (e.getMessage().contains("password")) {
                throw new ProviderUtilException(ProviderUtilExceptionCode.WRONG_KEYSTORE_PASSWORD, -1, msg, e);
            }
            if (e.getCause() instanceof KalkanException) {
                KalkanException ke = (KalkanException)e.getCause();
                if (ke.getErrorCode().equals(PCSCCode.WRONG_PIN) || ke.getErrorCode().equals(PCSCCode.INVALID_PIN_VALUE)) {
                    Object o;
                    Object sw = ke.get("SW");
                    if (sw != null) {
                        msg = msg + " \u041a\u043e\u0434: " + sw;
                    }
                    if ((o = ke.get("RetryCount")) != null) {
                        Integer retryCount = (Integer)ke.get("RetryCount");
                        throw new ProviderUtilException(ProviderUtilExceptionCode.WRONG_KEYSTORE_PASSWORD, retryCount, msg, ke);
                    }
                    throw new ProviderUtilException(ProviderUtilExceptionCode.WRONG_KEYSTORE_PASSWORD, -1, msg, ke);
                }
                if (ke.getErrorCode().equals(PCSCCode.BLOCKED_PIN)) {
                    throw new ProviderUtilException(ProviderUtilExceptionCode.BLOCKED_KEYSTORE_PASSWORD, "\u041f\u0430\u0440\u043e\u043b\u044c \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d.", ke);
                }
            }
            throw e;
        }
        return store;
    }

    @Deprecated
    public static Map<String, KeyStoreEntry> getKeyStoreEntries(Storage storage, String container, char[] password, Provider provider) throws IOException, KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, ProviderUtilException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStoreUtil.getKeyStore(storage, container, password, provider);
        HashMap<String, KeyStoreEntry> result = new HashMap<String, KeyStoreEntry>();
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
            if (cert != null) {
                result.put(alias, new KeyStoreEntry(alias, cert.getPublicKey().getAlgorithm(), cert));
                continue;
            }
            try {
                result.put(alias, new KeyStoreEntry(alias, keyStore.getKey(alias, password).getAlgorithm(), null));
            }
            catch (UnrecoverableKeyException e) {
                if (e.getMessage().contains(PCSCCode.INVALID_PRIVKEY.toString())) {
                    result.put(alias, new KeyStoreEntry(alias, "UNKNOWN", null));
                    continue;
                }
                throw e;
            }
        }
        return result;
    }

    public static Map<String, KeyStoreEntry> getKeyStoreEntries(Storage storage, String container, KNCACertificateType requiredKNCACertificateType, char[] password, Provider provider) throws IOException, KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, ProviderUtilException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStoreUtil.getKeyStore(storage, container, password, provider);
        return KeyStoreUtil.getKeyStoreEntries(keyStore, password, requiredKNCACertificateType);
    }

    public static Map<String, KeyStoreEntry> getKeyStoreEntries(KeyStore keyStore, char[] password, KNCACertificateType requiredKNCACertificateType) throws KeyStoreException, CertificateException, IOException, CertificateParsingException, ProviderUtilException, NoSuchAlgorithmException, UnrecoverableKeyException {
        HashMap<String, KeyStoreEntry> result = new HashMap<String, KeyStoreEntry>();
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
            if (requiredKNCACertificateType == null) {
                try {
                    result.put(alias, new KeyStoreEntry(alias, keyStore.getKey(alias, password).getAlgorithm(), cert));
                    continue;
                }
                catch (UnrecoverableKeyException e) {
                    if (e.getMessage().contains(PCSCCode.INVALID_PRIVKEY.toString())) {
                        result.put(alias, new KeyStoreEntry(alias, "UNKNOWN", null));
                        continue;
                    }
                    throw e;
                }
            }
            if (cert == null) continue;
            try {
                Set<KNCACertificateType> types = X509Util.getKNCACertificateType(cert);
                if (types == null || !types.contains((Object)requiredKNCACertificateType)) continue;
                result.put(alias, new KeyStoreEntry(alias, cert.getPublicKey().getAlgorithm(), cert));
            }
            catch (ProviderUtilException e) {
                if (e.getCode().equals((Object)ProviderUtilExceptionCode.UNKNOWN_KNCA_CERTIFICATE_TYPE)) continue;
                throw e;
            }
        }
        return result;
    }

    public static Map<String, KeyStoreEntry> getKeyStoreEntries(KeyStore keyStore, char[] password) throws KeyStoreException, CertificateException, IOException, CertificateParsingException, ProviderUtilException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return KeyStoreUtil.getKeyStoreEntries(keyStore, password, null);
    }

    public static SigningEntity getSigningEntityChained(KeyStore keyStore, String alias, char[] password, List<X509Certificate> caCerts) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, ProviderUtilException {
        List<X509Certificate> certChain;
        PrivateKey key = (PrivateKey)keyStore.getKey(alias, password);
        X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
        if (caCerts != null) {
            PKIXUtil pkixUtil = new PKIXUtil(cert, caCerts).allowExpired();
            pkixUtil.validate();
            certChain = pkixUtil.getCertificateChain();
        } else {
            certChain = new ArrayList<X509Certificate>();
            certChain.add(cert);
        }
        return new SigningEntity(key, certChain);
    }

    public static SigningEntity getSigningEntity(KeyStore keyStore, String alias, char[] password) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, ProviderUtilException {
        return KeyStoreUtil.getSigningEntityChained(keyStore, alias, password, null);
    }

    public static SigningEntity getSigningEntityDefaultChained(KeyStore keyStore, String alias, char[] password) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, ProviderUtilException {
        return KeyStoreUtil.getSigningEntityChained(keyStore, alias, password, KeyStoreUtil.getDefaultCACerts());
    }

    public static String genKeyPairAndGetCSR(Storage storage, String container, char[] password, String signatureAlgorithmId, int keyLength, X509Name subjectDN, X509ExtensionsGenerator extensionsGenerator, Provider provider) throws ProviderUtilException, KeyStoreException, NoSuchProviderException, CertificateException, IOException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, SignatureException, KalkanException {
        if (!KeyStoreUtil.validateSignatureAlgorithmId(signatureAlgorithmId)) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.UNKNOWN_ALGORITHM);
        }
        String csr = null;
        if (storage.isToken() && storage.equals((Object)Storage.KZIDCARD)) {
            KeyStoreUtil.validateKZIDCARDOwner(container, subjectDN);
        }
        String idCardAlias = null;
        KeyStore keyStore = KeyStoreUtil.getKeyStore(storage, storage.isToken() ? container : null, password, provider);
        if (Storage.KZIDCARD == storage) {
            Enumeration<String> aliases = keyStore.aliases();
            Date oldestDate = null;
            String oldestAlias = null;
            while (aliases.hasMoreElements()) {
                String enumAlias = aliases.nextElement();
                Certificate cert = keyStore.getCertificate(enumAlias);
                if (cert == null) {
                    idCardAlias = enumAlias;
                    break;
                }
                X509Certificate xcert = (X509Certificate)cert;
                if (xcert.getExtendedKeyUsage().contains(KeyPurposeId.id_kp_clientAuth.getId())) {
                    idCardAlias = enumAlias;
                }
                if (oldestDate == null) {
                    oldestDate = xcert.getNotAfter();
                    oldestAlias = enumAlias;
                }
                if (!oldestDate.after(xcert.getNotAfter())) continue;
                oldestDate = xcert.getNotAfter();
                oldestAlias = enumAlias;
            }
            if (idCardAlias == null) {
                idCardAlias = oldestAlias;
            }
        }
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(signatureAlgorithmId, provider.getName());
        if (storage.isToken()) {
            Smartcard smartcard = new Smartcard(storage.getName(), container);
            AKAlgorithmParameterSpec spec = Storage.KZIDCARD == storage ? new AKAlgorithmParameterSpec(smartcard, idCardAlias, password) : new AKAlgorithmParameterSpec(smartcard, password);
            spec.setKeyLength(keyLength);
            keyPairGenerator.initialize((AlgorithmParameterSpec)spec);
        } else {
            keyPairGenerator.initialize(keyLength);
        }
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        String keyId = Hex.encodeStr((byte[])KALKANUtils.createKeyId((PublicKey)keyPair.getPublic()));
        if (!storage.isToken()) {
            Certificate[] chain = new Certificate[]{null};
            keyStore.setKeyEntry(keyId, keyPair.getPrivate(), password, chain);
        }
        if (extensionsGenerator == null) {
            extensionsGenerator = new X509ExtensionsGenerator();
        }
        extensionsGenerator.addExtension(KNCAObjectIdentifiers.keystore_branch, false, (DEREncodable)new KeyStoreInfo(storage.getOid(), storage.isToken() ? null : container));
        DERSet criAttributes = null;
        if (!extensionsGenerator.isEmpty()) {
            criAttributes = new DERSet((DEREncodable)new X509Attribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest.getId(), (ASN1Encodable)extensionsGenerator.generate()));
        }
        csr = CSRUtil.genPKCS10CertificationRequest(signatureAlgorithmId, subjectDN, keyPair.getPublic(), criAttributes, keyPair.getPrivate());
        String keyStoreAbsoluteFileName = null;
        if (!storage.isToken()) {
            keyStoreAbsoluteFileName = KeyStoreUtil.getKeyStoreAbsoluteFileName(storage.name(), container, signatureAlgorithmId, keyId);
        }
        KeyStoreUtil.store(keyStoreAbsoluteFileName, keyStore, password);
        return csr;
    }

    public static String setX509Certificate(Storage storage, String container, char[] password, X509Certificate x509Certificate, Provider provider) throws CertificateException, NoSuchProviderException, IOException, KeyStoreException, NoSuchAlgorithmException, ProviderUtilException {
        boolean needsToBeRenamed = false;
        String result = null;
        String alias = X509Util.getKeyId(x509Certificate);
        DERObjectIdentifier keystoreOid = X509Util.getKeystoreOid(x509Certificate);
        if (keystoreOid != null && storage != Storage.getByOid((String)keystoreOid.getId())) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.UNSUITED_STORAGE, "\u0425\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u043a\u043b\u044e\u0447\u0435\u0439 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0443 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u043c\u0443 \u0432 \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u0438 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430.");
        }
        if (!storage.isToken()) {
            Set<KNCACertificateType> types;
            block10: {
                result = KeyStoreUtil.getSuitableKeySoreFilePath(storage, container, alias, password, provider);
                types = null;
                try {
                    types = X509Util.getKNCACertificateType(x509Certificate);
                }
                catch (ProviderUtilException e) {
                    if (e.getCode().equals((Object)ProviderUtilExceptionCode.UNKNOWN_KNCA_CERTIFICATE_TYPE)) break block10;
                    throw e;
                }
            }
            if (types != null && types.contains((Object)KNCACertificateType.AUTHENTICATION)) {
                needsToBeRenamed = true;
            }
        } else {
            result = container;
        }
        KeyStore keyStore = KeyStoreUtil.getKeyStore(storage, result, password, provider);
        try {
            keyStore.setCertificateEntry(alias, x509Certificate);
        }
        catch (KeyStoreException e) {
            KalkanException ke;
            if (e.getCause() instanceof KalkanException && (ke = (KalkanException)e.getCause()).getErrorCode().equals(PCSCCode.INAPPROPRIATE_CERT)) {
                throw new ProviderUtilException(ProviderUtilExceptionCode.INAPPROPRIATE_CERT, "\u0425\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u043a\u043b\u044e\u0447\u0435\u0439 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0439 \u043a\u043b\u044e\u0447, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0443 \u0434\u043b\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438.", ke);
            }
            throw e;
        }
        KeyStoreUtil.store(result, keyStore, password);
        if (needsToBeRenamed) {
            String newName = KeyStoreUtil.getAUTHFilePath(result);
            new File(result).renameTo(new File(newName));
            result = newName;
        }
        return result;
    }

    public static void changePassword(Storage storage, String container, char[] oldPassword, char[] newPassword, Provider provider) throws ProviderUtilException, KeyStoreException, IOException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyStoreUtil.validatePasswordPattern(storage, String.valueOf(newPassword));
        KeyStore keyStore = KeyStoreUtil.getKeyStore(storage, container, oldPassword, provider);
        if (storage.isToken()) {
            keyStore.store(null, newPassword);
        } else {
            Map<String, KeyStoreEntry> aliasCertMap = KeyStoreUtil.getKeyStoreEntries(storage, container, null, oldPassword, provider);
            if (aliasCertMap == null || aliasCertMap.isEmpty()) {
                throw new ProviderUtilException(ProviderUtilExceptionCode.CHANGE_PASSWORD_CONSTRAINT, "\u0414\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u043d\u043e\u0441\u0438\u0442\u0435\u043b\u044f \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c \u0434\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0433\u043e \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430.");
            }
            Iterator<String> it = aliasCertMap.keySet().iterator();
            while (it.hasNext()) {
                if (aliasCertMap.get(it.next()) != null) continue;
                throw new ProviderUtilException(ProviderUtilExceptionCode.CHANGE_PASSWORD_CONSTRAINT, "\u0414\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u043d\u043e\u0441\u0438\u0442\u0435\u043b\u044f \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c \u0434\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0433\u043e \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430.");
            }
            KeyStoreUtil.store(container, keyStore, newPassword);
        }
        keyStore = null;
    }

    public static void deleteEntry(Storage storage, String container, char[] password, String alias, Provider provider) throws KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, ProviderUtilException, IOException {
        KeyStore keyStore = KeyStoreUtil.getKeyStore(storage, container, password, provider);
        if (!storage.isToken()) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.UNKNOWN_STORAGE_FOR_THE_CURRENT_OPERATION);
        }
        keyStore.deleteEntry(alias);
        keyStore.store(null, null);
    }

    private static boolean isSpecifiedToken(String tName, Storage storage) {
        try {
            AKToken at = TokenDispatcher.INSTANCE.instantiateToken(storage.getName(), tName, null);
            System.out.println("tokenid: " + at.getTokenId());
            TokenDispatcher.INSTANCE.removeToken(at);
            return true;
        }
        catch (KalkanException e) {
            return false;
        }
    }

    private static void loadKeyStore(Storage storage, String container, KeyStore keyStore, char[] password) throws NoSuchAlgorithmException, IOException, CertificateException {
        if (storage.isToken()) {
            keyStore.load(Streams.fromString((String)container), password);
        } else if (container == null) {
            keyStore.load(null);
        } else {
            try (FileInputStream inputStream = new FileInputStream(container);){
                keyStore.load(inputStream, password);
            }
        }
    }

    private static void store(String container, KeyStore keyStore, char[] password) throws NoSuchAlgorithmException, IOException, CertificateException, KeyStoreException {
        if (keyStore.getType().equals(Storage.PKCS12.getName()) || keyStore.getType().equals(Storage.JKS.getName())) {
            try (FileOutputStream outputStream = new FileOutputStream(container);){
                keyStore.store(outputStream, password);
            }
        } else {
            keyStore.store(null, null);
        }
    }

    private static String getKeyStoreAbsoluteFileName(String storageName, String container, String signatureAlgorithmId, String keyId) throws ProviderUtilException {
        String keyStoreAbsoluteFileName = "";
        if (signatureAlgorithmId.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId())) {
            keyStoreAbsoluteFileName = "RSA_";
        } else if (signatureAlgorithmId.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId())) {
            keyStoreAbsoluteFileName = "RSA256_";
        } else if (signatureAlgorithmId.equals(CryptoProObjectIdentifiers.gostR3411_94_with_gostR34310_2004.getId())) {
            keyStoreAbsoluteFileName = "GOSTGT_";
        } else if (signatureAlgorithmId.equals(KNCAObjectIdentifiers.gost34311_95_with_gost34310_2004.getId())) {
            keyStoreAbsoluteFileName = "GOSTKNCA_";
        } else if (signatureAlgorithmId.equals(KNCAObjectIdentifiers.gost3411_2015_with_gost3410_2015_512.getId())) {
            keyStoreAbsoluteFileName = "GOST512_";
        } else {
            throw new ProviderUtilException(ProviderUtilExceptionCode.UNKNOWN_ALGORITHM);
        }
        keyStoreAbsoluteFileName = keyStoreAbsoluteFileName + keyId;
        keyStoreAbsoluteFileName = container.lastIndexOf(File.separatorChar) < container.length() - 1 ? container + File.separatorChar + keyStoreAbsoluteFileName : container + keyStoreAbsoluteFileName;
        keyStoreAbsoluteFileName = storageName.equals(Storage.PKCS12.getName()) ? keyStoreAbsoluteFileName + ".p12" : keyStoreAbsoluteFileName + ".jks";
        return keyStoreAbsoluteFileName;
    }

    private static String genKeyId() {
        SecureRandom sr = new SecureRandom();
        byte[] rnd = new byte[12];
        boolean hasZero = true;
        block0: while (hasZero) {
            sr.nextBytes(rnd);
            for (int j = 0; j < rnd.length; ++j) {
                if (rnd[j] == 0) {
                    hasZero = true;
                    continue block0;
                }
                hasZero = false;
            }
        }
        return Hex.encodeStr((byte[])rnd);
    }

    private static boolean validateSignatureAlgorithmId(String signatureAlgorithmId) {
        return SIGNATURE_ALGORITHM_IDS.contains(signatureAlgorithmId);
    }

    private static void validateKZIDCARDOwner(String container, X509Name subjectDN) throws ProviderUtilException, CertificateException, KalkanException {
        String subjectFirstName;
        String ownerIin = KeyStoreUtil.getPublicPartInfo(Storage.KZIDCARD, container, PublicPartInfo.IIN).toUpperCase();
        String ownerLastName = KeyStoreUtil.getPublicPartInfo(Storage.KZIDCARD, container, PublicPartInfo.LASTNAME).toUpperCase();
        String ownerFirstName = KeyStoreUtil.getPublicPartInfo(Storage.KZIDCARD, container, PublicPartInfo.FIRSTNAME).toUpperCase();
        String ownerMiddleName = KeyStoreUtil.getPublicPartInfo(Storage.KZIDCARD, container, PublicPartInfo.MIDDLENAME).toUpperCase();
        String subjectIin = X509Util.getRdn(subjectDN, X509Name.SERIALNUMBER, 0).substring(3);
        String subjectCommonName = X509Util.getRdn(subjectDN, X509Name.CN, 0);
        String subjectLastName = X509Util.getRdn(subjectDN, X509Name.SURNAME, 0);
        String string = subjectFirstName = subjectCommonName != null && subjectLastName != null ? subjectCommonName.replaceFirst(Pattern.quote(subjectLastName), "").trim() : null;
        if (subjectFirstName.isEmpty()) {
            subjectFirstName = null;
        }
        String subjectMiddleName = X509Util.getRdn(subjectDN, X509Name.G, 0);
        if (subjectIin == null || !subjectIin.equals(ownerIin)) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.INCORRECT_SUBJECTDN_VALUE, "\u0418\u0418\u041d \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0443\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u0435\u043d\u0438\u0435 \u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438 \u0438 \u0418\u0418\u041d \u0437\u0430\u044f\u0432\u0438\u0442\u0435\u043b\u044f \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442");
        }
        if (!(subjectLastName == null || ownerLastName != null && subjectLastName.equals(ownerLastName))) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.INCORRECT_SUBJECTDN_VALUE, "\u0424\u0430\u043c\u0438\u043b\u0438\u044f \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0443\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u0435\u043d\u0438\u0435 \u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438 \u0438 \u0444\u0430\u043c\u0438\u043b\u0438\u044f \u0437\u0430\u044f\u0432\u0438\u0442\u0435\u043b\u044f \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442");
        }
        if (!(subjectFirstName == null || ownerFirstName != null && subjectFirstName.equals(ownerFirstName))) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.INCORRECT_SUBJECTDN_VALUE, "\u0418\u043c\u044f \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0443\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u0435\u043d\u0438\u0435 \u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438 \u0438 \u0438\u043c\u044f \u0437\u0430\u044f\u0432\u0438\u0442\u0435\u043b\u044f \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442");
        }
        if (!(subjectMiddleName == null || ownerMiddleName != null && subjectMiddleName.equals(ownerMiddleName))) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.INCORRECT_SUBJECTDN_VALUE, "\u041e\u0442\u0447\u0435\u0441\u0442\u0432\u043e \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0443\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u0435\u043d\u0438\u0435 \u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438 \u0438 \u043e\u0442\u0447\u0435\u0441\u0442\u0432\u043e \u0437\u0430\u044f\u0432\u0438\u0442\u0435\u043b\u044f \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442");
        }
    }

    private static void validatePasswordPattern(Storage storage, String newPassword) throws ProviderUtilException {
        int maxLength;
        if (newPassword == null || newPassword.isEmpty()) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.WRONG_PASSWORD_PATTERN, "\u041f\u0443\u0441\u0442\u043e\u0439 \u043f\u0430\u0440\u043e\u043b\u044c \u043d\u0435 \u0434\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u0442\u0441\u044f.");
        }
        switch (storage) {
            case PKCS12: 
            case JKS: {
                maxLength = 32;
                break;
            }
            case JACARTA: 
            case ETOKEN_5110: {
                maxLength = 10;
                break;
            }
            case KAZTOKEN: 
            case ETOKEN_72K: 
            case AKEY: {
                maxLength = 32;
                break;
            }
            default: {
                throw new ProviderUtilException(ProviderUtilExceptionCode.UNKNOWN_STORAGE_FOR_THE_CURRENT_OPERATION, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c \u0434\u043b\u044f \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0433\u043e \u043d\u043e\u0441\u0438\u0442\u0435\u043b\u044f \u043a\u043b\u044e\u0447\u0435\u0439.");
            }
        }
        Matcher matcher = null;
        matcher = storage == Storage.PKCS12 ? Pattern.compile("^(?=.*\\d)(?=.*[a-zA-Z])[0-9a-z.?A-Z#$^+=!*()@%&_-]{6,32}$").matcher(newPassword) : Pattern.compile("[0-9a-z.?A-Z#$^+=!*()@%&_-]*$").matcher(newPassword);
        if (newPassword.length() > maxLength || !matcher.matches()) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.WRONG_PASSWORD_PATTERN, "\u041f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043b\u0430\u0442\u0438\u043d\u0441\u043a\u0438\u0435 \u0431\u0443\u043a\u0432\u044b, \u0430 \u0442\u0430\u043a\u0436\u0435 \u0446\u0438\u0444\u0440\u044b. \u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0434\u043b\u0438\u043d\u0430 \u0434\u043b\u044f \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0433\u043e \u043d\u043e\u0441\u0438\u0442\u0435\u043b\u044f \u043a\u043b\u044e\u0447\u0435\u0439 - " + maxLength + " \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432.");
        }
    }

    private static String getSuitableKeySoreFilePath(Storage storage, String container, String alias, char[] password, Provider provider) throws KeyStoreException, NoSuchProviderException, ProviderUtilException, NoSuchAlgorithmException, CertificateException {
        if (container != null) {
            File[] listFile;
            for (File f : listFile = new File(container).listFiles()) {
                String fileName = f.getName();
                String extension = "";
                int dotLastIndex = fileName.lastIndexOf(46);
                if (dotLastIndex > 0) {
                    extension = fileName.substring(dotLastIndex + 1);
                }
                if (!extension.equalsIgnoreCase(P12_EXTENSION) && !extension.equalsIgnoreCase(JKS_EXTENSION)) continue;
                try {
                    KeyStore keyStore = null;
                    try {
                        keyStore = KeyStoreUtil.getKeyStore(storage, f.getAbsolutePath(), password, provider);
                    }
                    catch (ProviderUtilException e) {
                        if (e.getCode().equals((Object)ProviderUtilExceptionCode.WRONG_KEYSTORE_PASSWORD)) continue;
                    }
                    if (keyStore == null || !keyStore.containsAlias(alias)) continue;
                    return f.getAbsolutePath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        throw new ProviderUtilException(ProviderUtilExceptionCode.KEYSTORE_FILE_NOT_FOUND, "\u041f\u043e \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u043c\u0443 \u043f\u0443\u0442\u0438 \"" + container + "\" \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0444\u0430\u0439\u043b, \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044b\u0439 \u0434\u043b\u044f \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u043a\u043b\u044e\u0447\u0435\u0439 \u0441 \u0430\u043b\u0438\u0430\u0441\u043e\u043c - " + alias + DOT);
    }

    private static String getAUTHFilePath(String container) {
        File f = new File(container);
        if (f.getName().startsWith("AUTH_") || f.getName().startsWith("auth_")) {
            return f.getAbsolutePath();
        }
        return f.getParent() + File.separator + "AUTH_" + f.getName();
    }

    public static List<X509Certificate> getDefaultCACerts() {
        if (defaultCACerts == null) {
            try {
                ArrayList<X509Certificate> caCerts = new ArrayList<X509Certificate>();
                KeyStore keyStore = KeyStore.getInstance("JKS", "KALKAN");
                keyStore.load(PKIXUtil.class.getResourceAsStream(CA_CERTS_STORE), "knca".toCharArray());
                Enumeration<String> aliases = keyStore.aliases();
                while (aliases.hasMoreElements()) {
                    caCerts.add((X509Certificate)keyStore.getCertificate(aliases.nextElement()));
                }
                defaultCACerts = Collections.unmodifiableList(caCerts);
            }
            catch (Exception e) {
                System.err.println("Could not fetch CA certificates!");
            }
        }
        return defaultCACerts;
    }

    static {
        SIGNATURE_ALGORITHM_IDS = new HashSet<String>();
        SIGNATURE_ALGORITHM_IDS.add(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId());
        SIGNATURE_ALGORITHM_IDS.add(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId());
        SIGNATURE_ALGORITHM_IDS.add(CryptoProObjectIdentifiers.gostR3411_94_with_gostR34310_2004.getId());
        SIGNATURE_ALGORITHM_IDS.add(KNCAObjectIdentifiers.gost34311_95_with_gost34310_2004.getId());
        SIGNATURE_ALGORITHM_IDS.add(KNCAObjectIdentifiers.gost3411_2015_with_gost3410_2015_512.getId());
    }
}

