/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.provider.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Hashtable;
import kz.gov.pki.kalkan.asn1.ASN1InputStream;
import kz.gov.pki.kalkan.asn1.ASN1OctetString;
import kz.gov.pki.kalkan.asn1.DEREncodable;
import kz.gov.pki.kalkan.asn1.DERObject;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.asn1.ocsp.OCSPObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x509.X509Extension;
import kz.gov.pki.kalkan.asn1.x509.X509Extensions;
import kz.gov.pki.kalkan.ocsp.BasicOCSPResp;
import kz.gov.pki.kalkan.ocsp.CertificateID;
import kz.gov.pki.kalkan.ocsp.CertificateStatus;
import kz.gov.pki.kalkan.ocsp.OCSPException;
import kz.gov.pki.kalkan.ocsp.OCSPReq;
import kz.gov.pki.kalkan.ocsp.OCSPReqGenerator;
import kz.gov.pki.kalkan.ocsp.OCSPResp;
import kz.gov.pki.kalkan.ocsp.SingleResp;
import kz.gov.pki.kalkan.util.encoders.Base64;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.exception.ProviderUtilExceptionCode;
import kz.gov.pki.reference.KNCAServiceRequestMethod;
import kz.gov.pki.reference.KalkanHashAlgorithm;

@Deprecated
public class OCSPUtil {
    public static CertificateStatus verify(X509Certificate cert, X509Certificate cacert, URL ocspUrl, KalkanHashAlgorithm hashAlgorithm, KNCAServiceRequestMethod method, boolean useNonce, Provider provider) throws IOException, OCSPException, NoSuchProviderException, ProviderUtilException {
        HttpURLConnection con;
        byte[] nonce = null;
        if (useNonce) {
            SecureRandom sr = new SecureRandom();
            nonce = new byte[4];
            sr.nextBytes(nonce);
        }
        byte[] ocspReq = OCSPUtil.getOcspPackage(cert.getSerialNumber(), cacert, hashAlgorithm.getId(), nonce, provider);
        if (method.equals((Object)KNCAServiceRequestMethod.POST)) {
            con = (HttpURLConnection)ocspUrl.openConnection();
            con.setDoOutput(true);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/ocsp-request");
            try (OutputStream os = con.getOutputStream();){
                os.write(ocspReq);
            }
        } else if (ocspUrl.getPath().endsWith("/")) {
            URL newurl = new URL(ocspUrl + new String(Base64.encode((byte[])ocspReq)));
            con = (HttpURLConnection)newurl.openConnection();
        } else {
            URL newurl = new URL(ocspUrl + "/" + new String(Base64.encode((byte[])ocspReq)));
            con = (HttpURLConnection)newurl.openConnection();
        }
        CertificateStatus result = OCSPUtil.makeOcspResponse(con, provider, nonce);
        con.disconnect();
        return result;
    }

    private static CertificateStatus makeOcspResponse(HttpURLConnection con, Provider provider, byte[] nonce) throws IOException, OCSPException, NoSuchProviderException, ProviderUtilException {
        X509Certificate ocspcert;
        OCSPResp response;
        try (InputStream in = con.getInputStream();){
            response = new OCSPResp(in);
        }
        if (response.getStatus() != 0) {
            throw new OCSPException("Unsuccessful request. Status: " + response.getStatus());
        }
        BasicOCSPResp brep = (BasicOCSPResp)response.getResponseObject();
        byte[] respNonceExt = brep.getExtensionValue(OCSPObjectIdentifiers.id_pkix_ocsp_nonce.getId());
        if (respNonceExt != null) {
            ASN1InputStream asn1In = new ASN1InputStream(respNonceExt);
            DERObject derObj = asn1In.readObject();
            asn1In.close();
            byte[] extV = DEROctetString.getInstance((Object)derObj).getOctets();
            asn1In = new ASN1InputStream(extV);
            derObj = asn1In.readObject();
            asn1In.close();
            if (!Arrays.equals(nonce, DEROctetString.getInstance((Object)derObj).getOctets())) {
                throw new ProviderUtilException(ProviderUtilExceptionCode.OCSP_NOT_EQUAL_NONCES);
            }
        }
        if (!brep.verify((ocspcert = brep.getCerts(provider.getName())[0]).getPublicKey(), provider.getName())) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.OCSP_RESPONSE_NOT_VERIFIED);
        }
        SingleResp[] singleResps = brep.getResponses();
        SingleResp singleResp = singleResps[0];
        return (CertificateStatus)singleResp.getCertStatus();
    }

    private static byte[] getOcspPackage(BigInteger serialNr, Certificate cacert, String hashAlg, byte[] nonce, Provider provider) throws OCSPException, IOException {
        OCSPReqGenerator gen = new OCSPReqGenerator();
        CertificateID certId = new CertificateID(hashAlg, (X509Certificate)cacert, serialNr, provider.getName());
        gen.addRequest(certId);
        if (nonce != null) {
            gen.setRequestExtensions(OCSPUtil.generateExtensions(nonce));
        }
        OCSPReq req = gen.generate();
        return req.getEncoded();
    }

    private static X509Extensions generateExtensions(byte[] nonce) {
        Hashtable<DERObjectIdentifier, X509Extension> exts = new Hashtable<DERObjectIdentifier, X509Extension>();
        X509Extension nonceext = new X509Extension(false, (ASN1OctetString)new DEROctetString((DEREncodable)new DEROctetString(nonce)));
        exts.put(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, nonceext);
        return new X509Extensions(exts);
    }
}

