/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.provider.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import kz.gov.pki.kalkan.asn1.knca.KNCAObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.ocsp.OCSPException;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.exception.ProviderUtilExceptionCode;
import kz.gov.pki.provider.utils.KeyStoreUtil;
import kz.gov.pki.provider.utils.model.SigningEntity;
import kz.gov.pki.provider.utils.verifier.Verifier;
import kz.gov.pki.provider.utils.verifier.VerifierFlags;
import kz.gov.pki.provider.utils.verifier.VerifyXMLSignatureResult;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.Transforms;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLUtil {
    private static final String UTF_8_ENCODING = "utf-8";

    public static String createXmlSignature(String xmlSource, KeyStore keyStore, String alias, char[] password, String tbsElementXPath, String signatureParentElementXPath, Provider provider) throws ProviderUtilException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, XMLSecurityException, IOException, TransformerException {
        SigningEntity signingEntity = KeyStoreUtil.getSigningEntity(keyStore, alias, password);
        return XMLUtil.createXmlSignature(signingEntity, xmlSource, tbsElementXPath, signatureParentElementXPath, provider);
    }

    public static String createXmlSignature(SigningEntity signingEntity, String xmlSource, Provider provider) throws ProviderUtilException {
        return XMLUtil.createXmlSignature(signingEntity, xmlSource, null, null, provider);
    }

    public static String createXmlSignature(SigningEntity signingEntity, String xmlSource, String tbsElementXPath, String signatureParentElementXPath, Provider provider) throws ProviderUtilException {
        String digestMethod;
        String signMethod;
        Document document;
        boolean isEmptyTbsElement;
        boolean bl = isEmptyTbsElement = tbsElementXPath == null || tbsElementXPath.isEmpty();
        if (!isEmptyTbsElement && signatureParentElementXPath != null && signatureParentElementXPath.equalsIgnoreCase(tbsElementXPath)) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.CREATE_XML_SIGNATURE_CONSTRAINT, "\u041f\u0440\u0438 \u043f\u043e\u0434\u043f\u0438\u0441\u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 XML, \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u043f\u043e\u0434\u043f\u0438\u0441\u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u043c \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u043c \u043f\u043e\u0434\u043f\u0438\u0441\u0438.");
        }
        try {
            document = XMLUtil.getDocument(xmlSource);
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.UNABLE_TO_PARSE_XML, (Throwable)ex);
        }
        PrivateKey privateKey = signingEntity.getKey();
        X509Certificate x509Certificate = signingEntity.getCertificateChain().get(0);
        String sigAlgOid = x509Certificate.getSigAlgOID();
        if (sigAlgOid.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId())) {
            signMethod = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha1";
            digestMethod = "http://www.w3.org/2001/04/xmldsig-more#sha1";
        } else if (sigAlgOid.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId())) {
            signMethod = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
            digestMethod = "http://www.w3.org/2001/04/xmlenc#sha256";
        } else if (sigAlgOid.equals(KNCAObjectIdentifiers.gost34311_95_with_gost34310_2004.getId())) {
            signMethod = "http://www.w3.org/2001/04/xmldsig-more#gost34310-gost34311";
            digestMethod = "http://www.w3.org/2001/04/xmldsig-more#gost34311";
        } else if (sigAlgOid.equals(KNCAObjectIdentifiers.gost3411_2015_with_gost3410_2015_512.getId())) {
            signMethod = "urn:ietf:params:xml:ns:pkigovkz:xmlsec:algorithms:gostr34102015-gostr34112015-512";
            digestMethod = "urn:ietf:params:xml:ns:pkigovkz:xmlsec:algorithms:gostr34112015-512";
        } else {
            throw new IllegalArgumentException("Incorrect algorithm: " + sigAlgOid);
        }
        try {
            if (isEmptyTbsElement) {
                Transforms transforms = new Transforms(document);
                transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
                transforms.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
                XMLSignature xmlSignature = new XMLSignature(document, "", signMethod);
                document.getFirstChild().appendChild(xmlSignature.getElement());
                xmlSignature.addDocument("", transforms, digestMethod);
                xmlSignature.addKeyInfo(x509Certificate);
                xmlSignature.sign((Key)privateKey);
            } else {
                XPath xPath = XMLUtil.initXPath();
                try {
                    Element tbsEl = (Element)xPath.evaluate(tbsElementXPath, document, XPathConstants.NODE);
                    if (tbsEl == null) {
                        throw new ProviderUtilException(ProviderUtilExceptionCode.CREATE_XML_SIGNATURE_CONSTRAINT, "\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u0434\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 " + tbsElementXPath + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                    }
                    String idAttr = tbsEl.getAttribute("Id");
                    if (idAttr.isEmpty()) {
                        throw new ProviderUtilException(ProviderUtilExceptionCode.CREATE_XML_SIGNATURE_CONSTRAINT, "\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u0434\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 'Id'");
                    }
                    tbsEl.setIdAttribute("Id", true);
                    Transforms transforms = new Transforms(document);
                    transforms.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
                    XMLSignature xmlSignature = new XMLSignature(document, "", signMethod, "http://www.w3.org/2001/10/xml-exc-c14n#");
                    xmlSignature.addDocument("#" + idAttr, transforms, digestMethod);
                    xmlSignature.addKeyInfo(x509Certificate);
                    xmlSignature.sign((Key)privateKey);
                    if (signatureParentElementXPath != null) {
                        Element signatureParentElement = (Element)xPath.evaluate(signatureParentElementXPath, document, XPathConstants.NODE);
                        signatureParentElement.appendChild(xmlSignature.getElement());
                    } else {
                        document.getFirstChild().appendChild(xmlSignature.getElement());
                    }
                }
                catch (XPathExpressionException e) {
                    throw new ProviderUtilException(ProviderUtilExceptionCode.UNABLE_TO_PARSE_XML, (Throwable)e);
                }
            }
            return XMLUtil.getXmlString(document);
        }
        catch (IOException | TransformerException | XMLSecurityException e) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.XML_SEC_PROCESSING_FAILURE, e);
        }
    }

    public static void verifyXmlSignature(Document document, Provider provider) throws ProviderUtilException {
        XMLUtil.verifyXmlSignature(document, null, provider);
    }

    public static void verifyXmlSignature(Document document, String signatureParentElementXPath, Provider provider) throws ProviderUtilException {
        boolean isEnveloped;
        boolean bl = isEnveloped = signatureParentElementXPath == null || signatureParentElementXPath.isEmpty();
        if (isEnveloped) {
            Element rootEl = (Element)document.getFirstChild();
            NodeList listSignatureEl = rootEl.getElementsByTagName("ds:Signature");
            int length = listSignatureEl.getLength();
            if (length < 1) {
                throw new ProviderUtilException(ProviderUtilExceptionCode.XML_SIGNATURE_OUT_OF_BOUND);
            }
            for (int i = 0; i < length; ++i) {
                int currentIndex = length - 1 - i;
                Element signatureEl = (Element)listSignatureEl.item(currentIndex);
                XMLUtil.verifySignature(signatureEl);
            }
        } else {
            try {
                XPath xpath = XMLUtil.initXPath();
                NodeList sigList = (NodeList)xpath.evaluate(signatureParentElementXPath + "/ds:Signature", document, XPathConstants.NODESET);
                if (sigList.getLength() < 1) {
                    throw new ProviderUtilException(ProviderUtilExceptionCode.XML_SIGNATURE_OUT_OF_BOUND);
                }
                for (int i = 0; i < sigList.getLength(); ++i) {
                    Element sigElement = (Element)sigList.item(i);
                    Element refElement = (Element)xpath.evaluate("ds:SignedInfo/ds:Reference[@URI]", sigElement, XPathConstants.NODE);
                    String refURI = refElement.getAttribute("URI").replaceFirst("#", "");
                    Element signedEl = (Element)xpath.evaluate("//*[@Id='" + refURI + "']", document, XPathConstants.NODE);
                    signedEl.setIdAttribute("Id", true);
                    XMLUtil.verifySignature(sigElement);
                }
            }
            catch (XPathExpressionException e) {
                throw new ProviderUtilException(ProviderUtilExceptionCode.UNABLE_TO_PARSE_XML, (Throwable)e);
            }
        }
    }

    public static Set<VerifyXMLSignatureResult> verifyXmlSignature(Document document, String signatureParentElementXPath, VerifierFlags verifyerFlags, Collection<X509Certificate> caCertList, Collection<X509CRL> crlList, Provider provider) throws ProviderUtilException, NoSuchAlgorithmException, XMLSecurityException, NoSuchProviderException, IOException, TransformerException, CertificateException, CertificateParsingException, InvalidAlgorithmParameterException, CertPathBuilderException {
        boolean isEnveloped;
        HashSet<VerifyXMLSignatureResult> resultSet = new HashSet<VerifyXMLSignatureResult>();
        boolean bl = isEnveloped = signatureParentElementXPath == null || signatureParentElementXPath.isEmpty();
        if (isEnveloped) {
            Element rootEl = (Element)document.getFirstChild();
            NodeList listSignatureEl = rootEl.getElementsByTagName("ds:Signature");
            int length = listSignatureEl.getLength();
            if (length < 1) {
                throw new ProviderUtilException(ProviderUtilExceptionCode.XML_SIGNATURE_OUT_OF_BOUND);
            }
            for (int i = 0; i < length; ++i) {
                int currentIndex = length - 1 - i;
                Element signatureEl = (Element)listSignatureEl.item(currentIndex);
                VerifyXMLSignatureResult result = XMLUtil.verifySignature(signatureEl, caCertList, crlList, verifyerFlags);
                result.setXmlDataAsString(XMLUtil.getXmlString(document));
                resultSet.add(result);
            }
        } else {
            try {
                XPath xpath = XMLUtil.initXPath();
                NodeList sigList = (NodeList)xpath.evaluate(signatureParentElementXPath + "/ds:Signature", document, XPathConstants.NODESET);
                for (int i = 0; i < sigList.getLength(); ++i) {
                    Element sigElement = (Element)sigList.item(i);
                    Element refElement = (Element)xpath.evaluate("ds:SignedInfo/ds:Reference[@URI]", sigElement, XPathConstants.NODE);
                    String refURI = refElement.getAttribute("URI").replaceFirst("#", "");
                    Element signedEl = (Element)xpath.evaluate("//*[@Id='" + refURI + "']", document, XPathConstants.NODE);
                    signedEl.setIdAttribute("Id", true);
                    VerifyXMLSignatureResult result = XMLUtil.verifySignature(sigElement, caCertList, crlList, verifyerFlags);
                    result.setId(refURI);
                    result.setXmlDataAsString(XMLUtil.getXmlString(signedEl));
                    resultSet.add(result);
                }
            }
            catch (XPathExpressionException e) {
                throw new ProviderUtilException(ProviderUtilExceptionCode.UNABLE_TO_PARSE_XML, (Throwable)e);
            }
        }
        return resultSet;
    }

    private static void verifySignature(Element sigElement) throws ProviderUtilException {
        block4: {
            try {
                XMLSignature signature = new XMLSignature(sigElement, "");
                KeyInfo ki = signature.getKeyInfo();
                X509Certificate x509Certificate = ki.getX509Certificate();
                if (x509Certificate != null) {
                    if (!signature.checkSignatureValue(x509Certificate)) {
                        throw new ProviderUtilException(ProviderUtilExceptionCode.XML_SIGNATURE_NOT_VALID);
                    }
                    break block4;
                }
                throw new ProviderUtilException(ProviderUtilExceptionCode.SIGNER_CERTIFICATE_NOT_FOUND);
            }
            catch (XMLSecurityException e) {
                throw new ProviderUtilException(ProviderUtilExceptionCode.XML_SEC_PROCESSING_FAILURE, (Throwable)e);
            }
        }
    }

    @Deprecated
    private static VerifyXMLSignatureResult verifySignature(Element sigElement, Collection<X509Certificate> caCertList, Collection<X509CRL> crlList, VerifierFlags verifyerFlags) throws XMLSignatureException, XMLSecurityException, KeyResolverException, CertificateParsingException, CertificateException, IOException, NoSuchAlgorithmException, NoSuchProviderException, ProviderUtilException, InvalidAlgorithmParameterException, CertPathBuilderException {
        XMLSignature signature = new XMLSignature(sigElement, "");
        KeyInfo ki = signature.getKeyInfo();
        X509Certificate x509Certificate = ki.getX509Certificate();
        VerifyXMLSignatureResult result = new VerifyXMLSignatureResult();
        if (x509Certificate != null) {
            if (verifyerFlags != null) {
                result.setVerifyX509CertifcateResult(Verifier.verifyX509Certificate(x509Certificate, caCertList, crlList, verifyerFlags));
                result.setValid(result.getVerifyX509CertifcateResult().isValid() && signature.checkSignatureValue(x509Certificate));
            } else {
                result.setValid(signature.checkSignatureValue(x509Certificate));
            }
        } else {
            throw new ProviderUtilException(ProviderUtilExceptionCode.SIGNER_CERTIFICATE_NOT_FOUND);
        }
        return result;
    }

    @Deprecated
    public static Set<VerifyXMLSignatureResult> verifyXmlSignature(Document document, String signatureParentElementXPath, VerifierFlags verifyerFlags, Map<String, X509Certificate> mapCaCert, URL ocspUrl, Provider provider) throws ProviderUtilException, NoSuchAlgorithmException, XMLSecurityException, NoSuchProviderException, IOException, TransformerException, CertificateException, CertificateParsingException, OCSPException {
        boolean isEnveloped;
        HashSet<VerifyXMLSignatureResult> resultSet = new HashSet<VerifyXMLSignatureResult>();
        boolean bl = isEnveloped = signatureParentElementXPath == null || signatureParentElementXPath.isEmpty();
        if (isEnveloped) {
            Element rootEl = (Element)document.getFirstChild();
            NodeList listSignatureEl = rootEl.getElementsByTagName("ds:Signature");
            int length = listSignatureEl.getLength();
            if (length < 1) {
                throw new ProviderUtilException(ProviderUtilExceptionCode.XML_SIGNATURE_OUT_OF_BOUND);
            }
            for (int i = 0; i < length; ++i) {
                int currentIndex = length - 1 - i;
                Element signatureEl = (Element)listSignatureEl.item(currentIndex);
                XMLSignature signature = new XMLSignature(signatureEl, "");
                KeyInfo ki = signature.getKeyInfo();
                X509Certificate x509Certificate = ki.getX509Certificate();
                VerifyXMLSignatureResult result = new VerifyXMLSignatureResult();
                if (x509Certificate != null) {
                    if (verifyerFlags != null) {
                        result.setVerifyX509CertifcateResult(Verifier.verifyX509Certificate(x509Certificate, mapCaCert, provider, ocspUrl, verifyerFlags));
                        result.setValid(result.getVerifyX509CertifcateResult().isValid() && signature.checkSignatureValue(x509Certificate));
                    } else {
                        result.setValid(signature.checkSignatureValue(x509Certificate));
                    }
                } else {
                    throw new ProviderUtilException(ProviderUtilExceptionCode.SIGNER_CERTIFICATE_NOT_FOUND);
                }
                rootEl.removeChild(signatureEl);
                result.setXmlDataAsString(XMLUtil.getXmlString(document));
                resultSet.add(result);
            }
        } else {
            try {
                XPath xpath = XMLUtil.initXPath();
                NodeList sigList = (NodeList)xpath.evaluate(signatureParentElementXPath + "/ds:Signature", document, XPathConstants.NODESET);
                for (int i = 0; i < sigList.getLength(); ++i) {
                    Element sigElement = (Element)sigList.item(i);
                    Element refElement = (Element)xpath.evaluate("ds:SignedInfo/ds:Reference[@URI]", sigElement, XPathConstants.NODE);
                    String refURI = refElement.getAttribute("URI").replaceFirst("#", "");
                    Element signedEl = (Element)xpath.evaluate("//*[@id='" + refURI + "']", document, XPathConstants.NODE);
                    signedEl.setIdAttribute("id", true);
                    XMLSignature signature = new XMLSignature(sigElement, "");
                    KeyInfo ki = signature.getKeyInfo();
                    X509Certificate x509Certificate = ki.getX509Certificate();
                    VerifyXMLSignatureResult result = new VerifyXMLSignatureResult();
                    if (x509Certificate != null) {
                        if (verifyerFlags != null) {
                            result.setVerifyX509CertifcateResult(Verifier.verifyX509Certificate(x509Certificate, mapCaCert, provider, ocspUrl, verifyerFlags));
                            result.setValid(result.getVerifyX509CertifcateResult().isValid() && signature.checkSignatureValue(x509Certificate));
                        } else {
                            result.setValid(signature.checkSignatureValue(x509Certificate));
                        }
                    } else {
                        throw new ProviderUtilException(ProviderUtilExceptionCode.SIGNER_CERTIFICATE_NOT_FOUND);
                    }
                    result.setId(refURI);
                    result.setXmlDataAsString(XMLUtil.getXmlString(signedEl));
                    resultSet.add(result);
                }
            }
            catch (XPathExpressionException e) {
                throw new ProviderUtilException(ProviderUtilExceptionCode.UNABLE_TO_PARSE_XML, (Throwable)e);
            }
        }
        return resultSet;
    }

    public static List<X509Certificate> getX509Certificates(Document document, String signatureParentElementXPath, Provider provider) throws ProviderUtilException, XMLSecurityException {
        boolean isEnveloped;
        ArrayList<X509Certificate> resultList = new ArrayList<X509Certificate>();
        boolean bl = isEnveloped = signatureParentElementXPath == null || signatureParentElementXPath.isEmpty();
        if (isEnveloped) {
            Element rootEl = (Element)document.getFirstChild();
            NodeList listSignatureEl = rootEl.getElementsByTagName("ds:Signature");
            int length = listSignatureEl.getLength();
            if (length < 1) {
                throw new ProviderUtilException(ProviderUtilExceptionCode.XML_SIGNATURE_OUT_OF_BOUND);
            }
            for (int i = 0; i < length; ++i) {
                int currentIndex = length - 1 - i;
                Element signatureEl = (Element)listSignatureEl.item(currentIndex);
                XMLSignature signature = new XMLSignature(signatureEl, "");
                KeyInfo ki = signature.getKeyInfo();
                X509Certificate x509Certificate = ki.getX509Certificate();
                if (x509Certificate == null) {
                    throw new ProviderUtilException(ProviderUtilExceptionCode.SIGNER_CERTIFICATE_NOT_FOUND);
                }
                resultList.add(x509Certificate);
            }
        } else {
            try {
                XPath xpath = XMLUtil.initXPath();
                NodeList sigList = (NodeList)xpath.evaluate(signatureParentElementXPath + "/ds:Signature", document, XPathConstants.NODESET);
                for (int i = 0; i < sigList.getLength(); ++i) {
                    Element sigElement = (Element)sigList.item(i);
                    Element refElement = (Element)xpath.evaluate("ds:SignedInfo/ds:Reference[@URI]", sigElement, XPathConstants.NODE);
                    String refURI = refElement.getAttribute("URI").replaceFirst("#", "");
                    Element signedEl = (Element)xpath.evaluate("//*[@Id='" + refURI + "']", document, XPathConstants.NODE);
                    signedEl.setIdAttribute("Id", true);
                    XMLSignature signature = new XMLSignature(sigElement, "");
                    KeyInfo ki = signature.getKeyInfo();
                    X509Certificate x509Certificate = ki.getX509Certificate();
                    if (x509Certificate == null) {
                        throw new ProviderUtilException(ProviderUtilExceptionCode.SIGNER_CERTIFICATE_NOT_FOUND);
                    }
                    resultList.add(x509Certificate);
                }
            }
            catch (XPathExpressionException e) {
                throw new ProviderUtilException(ProviderUtilExceptionCode.UNABLE_TO_PARSE_XML, (Throwable)e);
            }
        }
        return Collections.unmodifiableList(resultList);
    }

    public static List<String> getTbsElementXPathes(Document document) throws XPathExpressionException {
        ArrayList<String> resultList = new ArrayList<String>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList nodeList = (NodeList)xpath.evaluate("//*[@Id]", document, XPathConstants.NODESET);
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            String result = null;
            for (Node node = nodeList.item(i); node != null; node = node.getParentNode()) {
                if (node instanceof Element) {
                    Element element = (Element)node;
                    String idAttribute = element.getAttribute("Id");
                    String elemetName = idAttribute.isEmpty() ? element.getTagName() : element.getTagName() + "[@Id='" + idAttribute + "']";
                    result = result == null ? elemetName : elemetName + "/" + result;
                    continue;
                }
                result = result == null ? node.getNodeName() : node.getNodeName() + "/" + result;
            }
            if (result == null) continue;
            resultList.add(result.replace("#document", ""));
        }
        return resultList;
    }

    public static Document getDocument(String xml) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setNamespaceAware(true);
        DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
        return documentBuilder.parse(new ByteArrayInputStream(xml.getBytes(UTF_8_ENCODING)));
    }

    private static String getXmlString(Document document) throws TransformerException, IOException {
        try (StringWriter os = new StringWriter();){
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer trans = tf.newTransformer();
            trans.transform(new DOMSource(document), new StreamResult(os));
            String string = os.toString();
            return string;
        }
    }

    private static String getXmlString(Element el) throws TransformerException, IOException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        try (StringWriter sw = new StringWriter();){
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(el);
            transformer.transform(source, result);
            String string = result.getWriter().toString();
            return string;
        }
    }

    private static XPath initXPath() {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(new PkiNamespaceContext());
        return xpath;
    }

    static class PkiNamespaceContext
    implements NamespaceContext {
        PkiNamespaceContext() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix.equals("SOAP-ENV")) {
                return "http://schemas.xmlsoap.org/soap/envelope/";
            }
            return "http://www.w3.org/2000/09/xmldsig#";
        }

        @Override
        public String getPrefix(String namespaceURI) {
            if (namespaceURI.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                return "SOAP-ENV";
            }
            return "ds";
        }

        public Iterator<?> getPrefixes(String namespaceURI) {
            return null;
        }
    }
}

