/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.provider.utils.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kz.gov.pki.kalkan.asn1.ASN1Object;
import kz.gov.pki.kalkan.asn1.ASN1Set;
import kz.gov.pki.kalkan.asn1.cms.Attribute;
import kz.gov.pki.kalkan.asn1.cms.AttributeTable;
import kz.gov.pki.kalkan.asn1.knca.KNCAObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x509.GeneralName;
import kz.gov.pki.kalkan.asn1.x509.GeneralNames;
import kz.gov.pki.kalkan.asn1.x509.KeyStoreInfo;
import kz.gov.pki.kalkan.asn1.x509.X509Extension;
import kz.gov.pki.kalkan.asn1.x509.X509Extensions;
import kz.gov.pki.kalkan.jce.PKCS10CertificationRequest;

public class CsrExtensions {
    private final List<String> dnsNames = new ArrayList<String>();
    private String email;
    private KeyStoreInfo keyStoreInfo;

    public CsrExtensions(PKCS10CertificationRequest csr) {
        X509Extension extension;
        AttributeTable attributes = new AttributeTable(csr.getCertificationRequestInfo().getAttributes());
        Attribute attribute = attributes.get(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest);
        if (attribute == null) {
            throw new IllegalArgumentException("extensionRequest not found.");
        }
        ASN1Set values = attribute.getAttrValues();
        if (values.size() != 1) {
            throw new IllegalArgumentException("extensionRequest should contain only X509Extensions value.");
        }
        X509Extensions extensions = X509Extensions.getInstance((Object)values.getObjectAt(0));
        X509Extension subjectAltNameExt = extensions.getExtension(X509Extensions.SubjectAlternativeName);
        if (subjectAltNameExt != null) {
            try {
                ASN1Object subjectAltNameSeq = ASN1Object.fromByteArray((byte[])subjectAltNameExt.getValue().getOctets());
                GeneralNames generalNames = GeneralNames.getInstance((Object)subjectAltNameSeq);
                GeneralName[] names = generalNames.getNames();
                for (int i = 0; i < names.length; ++i) {
                    GeneralName generalName = names[i];
                    int tag = generalName.getTagNo();
                    if (tag == 2) {
                        this.dnsNames.add(generalName.getName().toString());
                        continue;
                    }
                    if (tag != 1) continue;
                    this.email = generalName.getName().toString();
                }
            }
            catch (IOException subjectAltNameSeq) {
                // empty catch block
            }
        }
        if ((extension = extensions.getExtension(KNCAObjectIdentifiers.keystore_branch)) != null) {
            try {
                ASN1Object derObject = ASN1Object.fromByteArray((byte[])extension.getValue().getOctets());
                this.keyStoreInfo = KeyStoreInfo.getInstance((Object)derObject);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public List<String> getDnsNames() {
        return this.dnsNames;
    }

    public String getEmail() {
        return this.email;
    }

    public KeyStoreInfo getKeyStoreInfo() {
        return this.keyStoreInfo;
    }
}

