/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.provider.utils.verifier;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kz.gov.pki.kalkan.asn1.x509.X509Name;
import kz.gov.pki.provider.utils.verifier.VerifierResult;
import kz.gov.pki.provider.utils.verifier.VerifierResultCode;
import kz.gov.pki.reference.KNCACertificateType;

public class VerifyX509CertifcateResult {
    private boolean valid = true;
    private List<VerifierResult> listVerifierResult;
    private String currentVerificationType;
    private X509Certificate x509Certificate;
    private String serialNumber;
    private Map<String, String[]> mapRdnOidValue;
    private String subjectDN;
    private String issuerDN;
    private Set<KNCACertificateType> setKNCACertificateType;
    private List<String> listExtKeyUsageOid;
    private String subjectKeyIdentifier;
    private String authorityKeyIdentifier;
    private boolean personCert;
    private String iin;
    private String bin;
    private String email;
    private String commonName;
    private String issuerCommonName;
    private String tab = "\t";

    public List<VerifierResult> getListVerifierResult() {
        return this.listVerifierResult;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void addVerifierResult(VerifierResult verifyerResult) {
        if (this.listVerifierResult == null) {
            this.listVerifierResult = new ArrayList<VerifierResult>();
        }
        this.listVerifierResult.add(verifyerResult);
        if (!verifyerResult.getCode().equals((Object)VerifierResultCode.NOT_VERIFIED)) {
            this.valid = verifyerResult.getCode().equals((Object)VerifierResultCode.SUCCESS);
        }
    }

    public String getAuthorityKeyIdentifier() {
        return this.authorityKeyIdentifier;
    }

    public void setAuthorityKeyIdentifier(String authorityKeyIdentifier) {
        this.authorityKeyIdentifier = authorityKeyIdentifier;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getSubjectDN() {
        return this.subjectDN;
    }

    public void setSubjectDN(String subjectDN) {
        this.subjectDN = subjectDN;
    }

    public String getIssuerDN() {
        return this.issuerDN;
    }

    public void setIssuerDN(String issuerDN) {
        this.issuerDN = issuerDN;
    }

    public List<String> getListExtKeyUsageOid() {
        return this.listExtKeyUsageOid;
    }

    public void setListExtKeyUsageOid(List<String> listExtKeyUsageOid) {
        this.listExtKeyUsageOid = listExtKeyUsageOid;
    }

    public Map<String, String[]> getMapRdnOidValue() {
        return this.mapRdnOidValue;
    }

    public void setMapRdnOidValue(Map<String, String[]> mapRdnOidValue) {
        this.mapRdnOidValue = mapRdnOidValue;
        if (this.getMapRdnOidValue() != null) {
            String[] valuesArray = this.getMapRdnOidValue().get(X509Name.E.getId());
            if (valuesArray != null && valuesArray.length > 0) {
                this.email = valuesArray[0];
            }
            if ((valuesArray = this.getMapRdnOidValue().get(X509Name.OU.getId())) != null) {
                for (String value : valuesArray) {
                    if (!value.contains("BIN") && !value.contains("bin") || value.length() != 15) continue;
                    this.bin = value.substring(3);
                }
            }
            if ((valuesArray = this.getMapRdnOidValue().get(X509Name.SERIALNUMBER.getId())) != null && valuesArray.length > 0) {
                this.iin = valuesArray[0].substring(3);
            }
            if ((valuesArray = this.getMapRdnOidValue().get(X509Name.CN.getId())) != null && valuesArray.length > 0) {
                this.commonName = valuesArray[0];
            }
        }
    }

    public String getCurrentVerificationType() {
        return this.currentVerificationType;
    }

    public void setCurrentVerificationType(String currentVerificationType) {
        this.currentVerificationType = currentVerificationType;
    }

    public X509Certificate getX509Certificate() {
        return this.x509Certificate;
    }

    public void setX509Certificate(X509Certificate x509Certificate) {
        this.x509Certificate = x509Certificate;
    }

    public Set<KNCACertificateType> getSetKNCACertificateType() {
        return this.setKNCACertificateType;
    }

    public void setSetKNCACertificateType(Set<KNCACertificateType> setKNCACertificateType) {
        this.setKNCACertificateType = setKNCACertificateType;
    }

    public boolean isPersonCert() {
        return this.personCert;
    }

    public void setPersonCert(boolean personCert) {
        this.personCert = personCert;
    }

    public String getSubjectKeyIdentifier() {
        return this.subjectKeyIdentifier;
    }

    public void setSubjectKeyIdentifier(String subjectKeyIdentifier) {
        this.subjectKeyIdentifier = subjectKeyIdentifier;
    }

    public String getBin() {
        return this.bin;
    }

    public String getIin() {
        return this.iin;
    }

    public String getEmail() {
        return this.email;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public String getIssuerCommonName() {
        return this.issuerCommonName;
    }

    public void setIssuerCommonName(String issuerCommonName) {
        this.issuerCommonName = issuerCommonName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        sb.append(this.tab.replaceFirst("\t", "")).append(this.getClass().getName()).append(" Object {").append(NEW_LINE);
        if (this.serialNumber != null && !this.serialNumber.isEmpty()) {
            sb.append(this.tab).append("serialNumber: ").append(this.serialNumber).append(NEW_LINE);
        }
        if (this.subjectKeyIdentifier != null && !this.subjectKeyIdentifier.isEmpty()) {
            sb.append(this.tab).append("subjectKeyIdentifier: ").append(this.subjectKeyIdentifier).append(NEW_LINE);
        }
        if (this.authorityKeyIdentifier != null && !this.authorityKeyIdentifier.isEmpty()) {
            sb.append(this.tab).append("authorityKeyIdentifier: ").append(this.authorityKeyIdentifier).append(NEW_LINE);
        }
        if (this.subjectDN != null && !this.subjectDN.isEmpty()) {
            sb.append(this.tab).append("subjectDN: ").append(this.subjectDN).append(NEW_LINE);
        }
        if (this.setKNCACertificateType != null && !this.setKNCACertificateType.isEmpty()) {
            sb.append(this.tab).append("setKNCACertificateType: ").append(this.setKNCACertificateType.toString()).append(NEW_LINE);
        }
        if (this.listExtKeyUsageOid != null && !this.listExtKeyUsageOid.isEmpty()) {
            sb.append(this.tab).append("listExtKeyUsageOid: ").append(this.listExtKeyUsageOid.toString()).append(NEW_LINE);
        }
        sb.append(this.tab).append("personCert: ").append(this.personCert).append(NEW_LINE);
        if (this.currentVerificationType != null && !this.currentVerificationType.isEmpty()) {
            sb.append(this.tab).append("currentVerificationType: ").append(this.currentVerificationType).append(NEW_LINE);
        }
        if (this.listVerifierResult != null && !this.listVerifierResult.isEmpty()) {
            sb.append(this.tab).append("listVerifierResult: ").append(this.listVerifierResult.toString()).append(NEW_LINE);
        }
        sb.append(this.tab).append("valid x509certificate: ").append(this.valid).append(NEW_LINE);
        sb.append(this.tab.replaceFirst("\t", "")).append("}");
        return sb.toString();
    }

    public String toString(int tabs) {
        if (tabs > 0) {
            for (int i = 0; i < tabs; ++i) {
                this.tab = this.tab + this.tab;
            }
        }
        String s = this.toString();
        this.tab = "\t";
        return s;
    }
}

