/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.adapter;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.commons.lang3.StringUtils;

public class CurrencyRateDateAdapter
extends XmlAdapter<String, Date> {
    private static Pattern DATE_PATTERN = Pattern.compile("^(?:(?:31(\\.)(?:0?[13578]|1[02]))\\1|(?:(?:29|30)(\\.)(?:0?[1,3-9]|1[0-2])\\2))(?:(?:1[6-9]|[2-9]\\d)?\\d{2})$|^(?:29(\\.)0?2\\3(?:(?:(?:1[6-9]|[2-9]\\d)?(?:0[48]|[2468][048]|[13579][26])|(?:(?:16|[2468][048]|[3579][26])00))))$|^(?:0?[1-9]|1\\d|2[0-8])(\\.)(?:(?:0?[1-9])|(?:1[0-2]))\\4(?:(?:1[6-9]|[2-9]\\d)?\\d{2})$");
    private static Pattern UGLY_DATE_PATTERN = Pattern.compile("^(.*),\\s(0[1-9]|[12][0-9]|3[01])\\s(.*)\\s\\d{4}\\s(2[0-3]|[01]?[0-9]):([0-5]?[0-9]):([0-5]?[0-9])\\s\\+\\d{4}$");
    private static final ThreadLocal<DateFormat> THREAD_LOCAL_DATE_FORMATTER = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("dd.MM.yyyy");
        }
    };
    private static final ThreadLocal<DateFormat> THREAD_LOCAL_UGLY_DATE_FORMATTER = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
        }
    };

    public String marshal(Date value) {
        return value != null ? THREAD_LOCAL_DATE_FORMATTER.get().format(value) : null;
    }

    public Date unmarshal(String value) throws Exception {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        if (!DATE_PATTERN.matcher(value).matches()) {
            if (UGLY_DATE_PATTERN.matcher(value).matches()) {
                return THREAD_LOCAL_UGLY_DATE_FORMATTER.get().parse(value);
            }
            throw new ParseException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u0442\u044b: " + value, 0);
        }
        return THREAD_LOCAL_DATE_FORMATTER.get().parse(value);
    }
}

