/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.model;

import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.model.ErrorCode;
import ru.uss.core.model.ValidationError;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Error")
@Documentation(value="\u041e\u0431\u044a\u0435\u043a\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0449\u0438\u0439 \u043e\u0448\u0438\u0431\u043a\u0438 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430")
public class Error
implements ValidationError {
    @XmlTransient
    @Documentation(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430, \u0432 \u043a\u043e\u0442\u043e\u0440\u043e\u043c \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0430 \u043e\u0448\u0438\u0431\u043a\u0430")
    private Long documentId;
    @XmlElement
    @Documentation(value="\u041f\u043e\u043b\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430, \u0432 \u043a\u043e\u0442\u043e\u0440\u043e\u043c \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0430 \u043e\u0448\u0438\u0431\u043a\u0430")
    private String property;
    @XmlElement
    @Documentation(value="\u041a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438")
    private ErrorCode errorCode;
    @XmlElement
    @Documentation(value="\u0422\u0435\u043a\u0441\u0442 \u043e\u0448\u0438\u0431\u043a\u0438")
    private String text;

    public Error() {
    }

    public Error(String property, String text) {
        this(null, property, null, text);
    }

    public Error(Long id, String text) {
        this(id, null, null, text);
    }

    public Error(Long id, ErrorCode errorCode) {
        this(id, null, errorCode, null);
    }

    public Error(Long id, String property, ErrorCode errorCode) {
        this(id, property, errorCode, null);
    }

    public Error(String property, ErrorCode errorCode, String text) {
        this.property = property;
        this.errorCode = errorCode;
        this.text = text;
    }

    public Error(Long id, String property, ErrorCode errorCode, String text) {
        this.documentId = id;
        this.property = property;
        this.errorCode = errorCode;
        this.text = text;
        if (StringUtils.isEmpty((CharSequence)property) && errorCode == null && StringUtils.isEmpty((CharSequence)text)) {
            try {
                throw new Exception("\u041e\u0448\u0438\u0431\u043a\u0430 \u0431\u0435\u0437 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Error of(String property, ErrorCode errorCode) {
        return new Error(null, property, errorCode);
    }

    public static Error of(String property, String text, ErrorCode errorCode) {
        Error error = new Error();
        error.setErrorCode(errorCode);
        error.setProperty(property);
        error.setText(text);
        return error;
    }

    public static Error of(Long id, String property, ErrorCode errorCode) {
        return new Error(id, property, errorCode);
    }

    @Override
    public Long getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }

    @Override
    public String getProperty() {
        return this.property;
    }

    public void setProperty(String value) {
        this.property = value;
    }

    @Override
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public void setText(String value) {
        this.text = value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Error[");
        if (this.documentId != null) {
            builder.append("documentId='").append(this.documentId).append("';");
        }
        if (this.property != null) {
            builder.append("property='").append(this.property).append("';");
        }
        if (this.errorCode != null) {
            builder.append("errorCode='").append((Object)this.errorCode).append("';");
        }
        if (this.text != null) {
            builder.append("text='").append(this.text).append("';");
        }
        builder.append("]");
        return builder.toString();
    }

    public static List<Error> errors(String property, String text) {
        return Collections.singletonList(new Error(property, text));
    }
}

