/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Optional;

public final class BigDecimalUtils {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat();
    private static final DecimalFormat DECIMAL_FORMAT_3 = new DecimalFormat();
    private static final DecimalFormat DECIMAL_FORMAT_6 = new DecimalFormat();

    private BigDecimalUtils() {
    }

    public static BigDecimal zeroIfNull(BigDecimal value) {
        return BigDecimalUtils.defaultIfNull(value, BigDecimal.ZERO);
    }

    public static BigDecimal defaultIfNull(BigDecimal value, BigDecimal defaultValue) {
        return Optional.ofNullable(value).orElse(defaultValue);
    }

    public static String toString(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return null;
        }
        bigDecimal = bigDecimal.setScale(2, 1);
        return DECIMAL_FORMAT.format(bigDecimal);
    }

    public static String parseString(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return null;
        }
        bigDecimal = bigDecimal.setScale(3, 1);
        return DECIMAL_FORMAT_3.format(bigDecimal);
    }

    public static String toStringWithoutTrailingZeros(BigDecimal bigDecimal) {
        if ((bigDecimal = BigDecimalUtils.stripTrailingZeros(bigDecimal)) == null) {
            return null;
        }
        return DECIMAL_FORMAT_6.format(bigDecimal);
    }

    public static boolean lessThanZero(BigDecimal number) {
        return number != null && BigDecimal.ZERO.compareTo(number) > 0;
    }

    public static boolean lessThanOrEqualsZero(BigDecimal number) {
        return BigDecimalUtils.lessThanZero(number) || BigDecimalUtils.isZero(number);
    }

    public static boolean isZero(BigDecimal number) {
        return number != null && BigDecimal.ZERO.compareTo(number) == 0;
    }

    public static boolean isNonZero(BigDecimal number) {
        return number != null && !BigDecimalUtils.isZero(number);
    }

    public static boolean greaterThanZero(BigDecimal number) {
        return number != null && BigDecimal.ZERO.compareTo(number) < 0;
    }

    public static boolean greaterThanOrEqualsZero(BigDecimal number) {
        return BigDecimalUtils.greaterThanZero(number) || BigDecimalUtils.isZero(number);
    }

    public static BigDecimal stripTrailingZeros(BigDecimal value) {
        if (value == null) {
            return null;
        }
        if (value.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        if ((value = value.stripTrailingZeros()).scale() < 0) {
            value = value.setScale(0);
        }
        return value;
    }

    public static boolean equals(BigDecimal one, BigDecimal another) {
        return one == another || one != null && one.compareTo(another) == 0;
    }

    public static BigDecimal min(BigDecimal value1, BigDecimal value2) {
        return value1.compareTo(value2) > 0 ? value2 : value1;
    }

    public static void main(String[] args) {
        System.out.println(BigDecimalUtils.toStringWithoutTrailingZeros(BigDecimal.valueOf(0.12008007)));
    }

    static {
        DECIMAL_FORMAT.setMaximumFractionDigits(2);
        DECIMAL_FORMAT.setMinimumFractionDigits(0);
        DECIMAL_FORMAT.setGroupingUsed(true);
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.getDefault());
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormatSymbols.setGroupingSeparator(' ');
        DECIMAL_FORMAT.setDecimalFormatSymbols(decimalFormatSymbols);
        DECIMAL_FORMAT_3.setMaximumFractionDigits(3);
        DECIMAL_FORMAT_3.setMinimumFractionDigits(3);
        DECIMAL_FORMAT_3.setGroupingUsed(true);
        DECIMAL_FORMAT_3.setDecimalFormatSymbols(decimalFormatSymbols);
        DECIMAL_FORMAT_6.setMaximumFractionDigits(6);
        DECIMAL_FORMAT_6.setMinimumFractionDigits(0);
        DECIMAL_FORMAT_6.setGroupingUsed(true);
        DECIMAL_FORMAT_6.setDecimalFormatSymbols(decimalFormatSymbols);
    }
}

