/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.utils;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

public class DistributionUtils {
    public static boolean checkShareWithDeltaParticipant(BigDecimal participantsTotalSum, BigDecimal participantSharedSum, Collection<BigDecimal> shares, BigDecimal share, int scale, boolean isDeltaParticipant) {
        BigDecimal totalShares = shares.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal calculatedSharedSum = participantsTotalSum.multiply(share).divide(totalShares, scale, 1);
        BigDecimal calculatedDelta = participantSharedSum.subtract(calculatedSharedSum);
        if (isDeltaParticipant) {
            BigDecimal maxDelta = DistributionUtils.maxDeltaWithDeltaParticipant(participantsTotalSum, shares, scale);
            return maxDelta.subtract(calculatedDelta).compareTo(BigDecimal.ZERO) >= 0;
        }
        return BigDecimal.ZERO.equals(calculatedDelta);
    }

    private static BigDecimal maxDeltaWithDeltaParticipant(BigDecimal totalSum, Collection<BigDecimal> shares, int scale) {
        BigDecimal totalShares = shares.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal unadjustedSum = shares.stream().map(share -> totalSum.multiply((BigDecimal)share).divide(totalShares, scale, 1)).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal delta = totalSum.subtract(unadjustedSum);
        return delta;
    }

    public static boolean checkShare(BigDecimal totalSum, BigDecimal sharedSum, BigDecimal totalShares, List<BigDecimal> shares, BigDecimal share, int scale) {
        BigDecimal calculatedDelta2;
        BigDecimal maxDelta = DistributionUtils.maxDelta(totalSum, totalShares, shares, scale);
        BigDecimal calculatedSharedSum1 = totalSum.multiply(share).divide(totalShares, 2, 4);
        BigDecimal calculatedSharedSum2 = totalSum.multiply(share).divide(totalShares, 2, 1);
        BigDecimal calculatedDelta1 = sharedSum.subtract(calculatedSharedSum1).abs();
        BigDecimal minCalculatedDelta = calculatedDelta1.compareTo(calculatedDelta2 = sharedSum.subtract(calculatedSharedSum2).abs()) < 0 ? calculatedDelta1 : calculatedDelta2;
        return maxDelta.subtract(minCalculatedDelta).compareTo(BigDecimal.ZERO) >= 0;
    }

    private static BigDecimal maxDelta(BigDecimal totalSum, BigDecimal totalShares, List<BigDecimal> shares, int scale) {
        BigDecimal delta2;
        BigDecimal unadjustedSum1 = shares.stream().map(share -> totalSum.multiply((BigDecimal)share).divide(totalShares, 2, 4)).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal unadjustedSum2 = shares.stream().map(share -> totalSum.multiply((BigDecimal)share).divide(totalShares, 2, 1)).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal delta1 = totalSum.subtract(unadjustedSum1).abs();
        return delta1.compareTo(delta2 = totalSum.subtract(unadjustedSum2).abs()) > 0 ? delta1 : delta2;
    }

    public static BigDecimal nvl(BigDecimal value) {
        return value == null ? BigDecimal.ZERO : value;
    }
}

