/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.utils;

import java.util.function.Function;

public class LambdaUtils {
    public static <I, R> R nullSafeApplyFunction(I i, Function<I, R> function) {
        return LambdaUtils.nullSafeApplyFunction(i, function, null);
    }

    public static <I, R> R nullSafeApplyFunction(I i, Function<I, R> function, R defaultValue) {
        return LambdaUtils.nullSafeApplyFunction(i, function, true, defaultValue);
    }

    public static <I, R> R nullSafeApplyFunction(I i, Function<I, R> function, boolean allowNullResult, R defaultValue) {
        try {
            R resultValue = function.apply(i);
            if (resultValue == null && !allowNullResult) {
                return defaultValue;
            }
            return resultValue;
        }
        catch (NullPointerException e) {
            return defaultValue;
        }
    }

    public static <I, R> R exceptionSafeApplyFunction(I i, Function<I, R> function, boolean allowNullResult, R defaultValue) {
        try {
            R resultValue = function.apply(i);
            if (resultValue == null && !allowNullResult) {
                return defaultValue;
            }
            return resultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static <I, R> R exceptionSafeApplyFunction(I i, Function<I, R> function) {
        return LambdaUtils.exceptionSafeApplyFunction(i, function, null);
    }

    public static <I, R> R exceptionSafeApplyFunction(I i, Function<I, R> function, R defaultValue) {
        return LambdaUtils.exceptionSafeApplyFunction(i, function, true, defaultValue);
    }
}

