/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.validation.common;

import java.util.HashSet;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.core.validation.common.EqualFields;
import ru.uss.core.validation.common.FieldUtils;

public class EqualFieldsValidator
extends AbstractClassLevelValidator<EqualFields, Object> {
    private String[] fields;
    private String message;

    public void initialize(EqualFields constraintAnnotation) {
        this.fields = constraintAnnotation.fields();
        this.message = constraintAnnotation.message();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        HashSet<Object> valueSet = new HashSet<Object>();
        for (String fieldName : this.fields) {
            valueSet.add(FieldUtils.getFieldValue(value, fieldName));
        }
        if (valueSet.size() > 1) {
            return this.setupContextWithValidationError(context, this.message);
        }
        return true;
    }
}

