/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.validation.common;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.utils.DateTimeUtils;
import ru.uss.core.validation.common.AbstractFieldLevelValidator;
import ru.uss.core.validation.common.FutureOrCurrentDate;

public class FutureOrCurrentDateValidator
extends AbstractFieldLevelValidator<FutureOrCurrentDate, Date> {
    private static SimpleDateFormat SHORT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private int calendarUnitType;
    private int calendarUnitAmount;
    private String fieldPath;

    public void initialize(FutureOrCurrentDate annotation) {
        this.calendarUnitType = annotation.calendarUnitType();
        this.calendarUnitAmount = annotation.calendarUnitAmount();
        this.fieldPath = annotation.fieldPath();
    }

    public boolean isValid(Date value, ConstraintValidatorContext context) {
        Date startOfTodayDate = DateTimeUtils.startOfTheDay(new Date());
        if (this.calendarUnitType != -1 && this.calendarUnitAmount != -1) {
            Calendar maxDateCalendar = GregorianCalendar.getInstance();
            maxDateCalendar.add(this.calendarUnitType, this.calendarUnitAmount);
            Date maxDate = DateTimeUtils.endOfTheDay(maxDateCalendar.getTime());
            if (value != null && (value.after(maxDate) || value.before(startOfTodayDate))) {
                return this.setupContextWithValidationError(context, "{" + this.fieldPath + "} {dateIntervalStart} " + SHORT_DATE_FORMAT.format(maxDate) + " {dateIntervalEnd} " + SHORT_DATE_FORMAT.format(startOfTodayDate));
            }
        } else if (value != null && value.before(startOfTodayDate)) {
            return this.setupContextWithValidationError(context, "{" + this.fieldPath + "} {dateIntervalOnlyFuture}");
        }
        return true;
    }
}

