/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.validation.common;

import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.core.validation.common.Gtin;

public class GtinValidator
extends AbstractClassLevelValidator<Gtin, String> {
    public void initialize(Gtin constraintAnnotation) {
        this.annotation = constraintAnnotation;
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        boolean validFlag = GtinValidator.isGtin(value);
        if (!validFlag) {
            this.addConstraintViolation(context, "object.code", ((Gtin)this.annotation).message());
        }
        return validFlag;
    }

    public static boolean isGtin(String gtin) {
        if (StringUtils.isEmpty((CharSequence)gtin)) {
            return false;
        }
        return GtinValidator.isValidGtin(gtin);
    }

    public static boolean isValidGtin(String gtin) {
        int calculatedControlDigit;
        if (gtin.length() != 8 && gtin.length() != 12 && gtin.length() != 13 && gtin.length() != 14) {
            return false;
        }
        int[] gtinDigits = GtinValidator.toIntArray(gtin);
        int controlDigit = gtinDigits[gtin.length() - 1];
        return controlDigit == (calculatedControlDigit = GtinValidator.calculateCheckDigitGtin(gtinDigits));
    }

    public static int calculateCheckDigitGtin(int[] gtin) {
        int oddSum = 0;
        int evenSum = 0;
        int shiftCorrection = gtin.length % 2;
        for (int i = 0; i < gtin.length - 1; ++i) {
            if ((i + shiftCorrection) % 2 == 0) {
                oddSum += gtin[i];
                continue;
            }
            evenSum += gtin[i];
        }
        int lastDigit = (oddSum * 3 + evenSum) % 10;
        return lastDigit == 0 ? 0 : 10 - lastDigit;
    }

    private static int[] toIntArray(String value) {
        char[] valueCh = value.toCharArray();
        int[] intArray = new int[valueCh.length];
        for (int i = 0; i < valueCh.length; ++i) {
            intArray[i] = Character.digit(valueCh[i], 10);
        }
        return intArray;
    }

    public static String correctGtin(String gtin) {
        if (gtin != null && gtin.length() > 8 && gtin.length() < 13) {
            return ("0000000000000" + gtin).substring(gtin.length());
        }
        return gtin;
    }
}

