/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.validation.common;

import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import ru.uss.core.validation.common.NotStartWith;

public class NotStartWithValidator
implements ConstraintValidator<NotStartWith, String> {
    private String patternField;
    private static final String PATTERN_FORMAT = "^%s.*";

    public void initialize(NotStartWith constraintAnnotation) {
        this.patternField = constraintAnnotation.regexp();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        Pattern pattern = Pattern.compile(String.format(PATTERN_FORMAT, this.patternField));
        return !pattern.matcher(value).matches();
    }
}

