/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonView;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import ru.uss.core.model.Error;
import ru.uss.esf.model.JsonViews;

public class Result
implements Serializable {
    @JsonView(value={JsonViews.Result.class})
    private final boolean success;
    @JsonUnwrapped
    @JsonView(value={JsonViews.Result.class})
    private final Map<String, String> data;
    @JsonView(value={JsonViews.Result.class})
    private final List<Error> errors;

    private Result(boolean success, Map<String, String> data, List<Error> errors) {
        this.success = success;
        this.data = data;
        this.errors = errors;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public static Result success() {
        return new Result(true, null, null);
    }

    public static Result success(Map<String, String> data) {
        return new Result(true, data, null);
    }

    public static Result fail() {
        return new Result(false, null, Collections.emptyList());
    }

    public static Result fail(List<Error> errors) {
        return new Result(false, null, errors);
    }
}

