/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.awp.version.v1;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import ru.uss.core.validation.common.RequiredString;
import ru.uss.esf.model.awp.abstractawp.AbstractAwp;
import ru.uss.esf.model.awp.abstractawp.AbstractAwpParticipant;
import ru.uss.esf.model.awp.version.v1.AwpContractV1;
import ru.uss.esf.model.awp.version.v1.AwpRecipientParticipantV1;
import ru.uss.esf.model.awp.version.v1.AwpSenderParticipantV1;
import ru.uss.esf.model.awp.version.v1.AwpWorksPerformedV1;
import ru.uss.esf.validation.awp.ImmutableForFixedAwp;
import ru.uss.esf.validation.awp.version.v1.AwpBankDetailsCheckV1;
import ru.uss.esf.validation.awp.version.v1.AwpPerformedDateCheckV1;
import ru.uss.esf.validation.awp.version.v1.AwpTypeCheckV1;
import ru.uss.esf.validation.awp.version.v1.SenderAndRecipientNotEqualV1;
import ru.uss.esf.validation.awp.version.v1.SenderCategoryCheckV1;

@AwpTypeCheckV1
@AwpPerformedDateCheckV1
@SenderCategoryCheckV1
@SenderAndRecipientNotEqualV1
@AwpBankDetailsCheckV1
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="awp")
@XmlType(name="AwpV1")
@Documentation(value="\u0410\u0412\u0420")
public class AwpV1
extends AbstractAwp {
    @ImmutableForFixedAwp
    @Valid
    @Size(min=1, max=1)
    @XmlElementWrapper(name="senders")
    @XmlElement(name="sender", required=true)
    @Documentation(value="\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b \u0418\u0441\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044f (\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430) (B), (C)")
    private @Valid @Size(min=1, max=1) List<AwpSenderParticipantV1> senders;
    @ImmutableForFixedAwp
    @Valid
    @Size(min=1, max=1)
    @XmlElementWrapper(name="recipients")
    @XmlElement(name="recipient", required=true)
    @Documentation(value="\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b \u0417\u0430\u043a\u0430\u0437\u0447\u0438\u043a\u0430 (\u041f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f) (D), (E)")
    private @Valid @Size(min=1, max=1) List<AwpRecipientParticipantV1> recipients;
    @Valid
    @NotNull(message="{contract.notNull}")
    @Documentation(value="\u0414\u043e\u0433\u043e\u0432\u043e\u0440 (\u041a\u043e\u043d\u0442\u0440\u0430\u043a\u0442) (F)")
    private @Valid @NotNull(message="{contract.notNull}") AwpContractV1 contract;
    @Valid
    @NotNull(message="{worksPerformed.notNull}")
    @Documentation(value="\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043d\u044b\u043c \u0440\u0430\u0431\u043e\u0442\u0430\u043c (\u041e\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u0443\u0441\u043b\u0443\u0433\u0430\u043c) (G)")
    private @Valid @NotNull(message="{worksPerformed.notNull}") AwpWorksPerformedV1 worksPerformed;
    @RequiredString(required=false, fieldPath="awp.additionalStock", minLen=1, maxLen=400)
    @XmlElement(required=false)
    @Documentation(value="\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e\u0431 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438 \u0437\u0430\u043f\u0430\u0441\u043e\u0432, \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043d\u044b\u0445 \u043e\u0442 \u0437\u0430\u043a\u0430\u0437\u0447\u0438\u043a\u0430")
    private String additionalStock;
    @RequiredString(required=false, fieldPath="awp.additionalName", minLen=1, maxLen=400)
    @XmlElement(required=false)
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435, \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e, \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c")
    private String additionalName;
    @RequiredString(required=false, fieldPath="awp.additionalAppendix", minLen=1, maxLen=150)
    @XmlElement(required=false)
    @Documentation(value="\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435: \u041f\u0435\u0440\u0435\u0447\u0435\u043d\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430\u0446\u0438\u0438, \u0432 \u0442\u043e\u043c \u0447\u0438\u0441\u043b\u0435 \u043e\u0442\u0447\u0435\u0442(\u044b) \u043e \u043c\u0430\u0440\u043a\u0435\u0442\u0438\u043d\u0433\u043e\u0432\u044b\u0445, \u043d\u0430\u0443\u0447\u043d\u044b\u0445 \u0438\u0441\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u044f\u0445, \u043a\u043e\u043d\u0441\u0443\u043b\u044c\u0442\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0445 \u0438 \u043f\u0440\u043e\u0447\u0438\u0445 \u0443\u0441\u043b\u0443\u0433\u0430\u0445 (\u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b \u043f\u0440\u0438 \u0435\u0433\u043e (\u0438\u0445) \u043d\u0430\u043b\u0438\u0447\u0438\u0438) \u043d\u0430 ___ \u0441\u0442\u0440\u0430\u043d\u0438\u0446")
    private String additionalAppendix;
    @RequiredString(required=false, fieldPath="awp.additionalInfo", minLen=1, maxLen=400)
    @XmlElement(required=false)
    @Documentation(value="\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0441\u0432\u0435\u0434\u0435\u043d\u0438\u044f/\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e\u0431 \u043e\u0442\u0447\u0435\u0442\u0435 \u043e \u043d\u0430\u0443\u0447\u043d\u044b\u0445 \u0438\u0441\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u044f\u0445, \u043c\u0430\u0440\u043a\u0435\u0442\u0438\u043d\u0433\u043e\u0432\u044b\u0445. \u041a\u043e\u043d\u0441\u0443\u043b\u044c\u0442\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0445 \u0438 \u043f\u0440\u043e\u0447\u0438\u0445 \u0443\u0441\u043b\u0443\u0433\u0430\u0445 (\u0434\u0430\u0442\u0430, \u043d\u043e\u043c\u0435\u0440. \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u0442\u0440\u0430\u043d\u0438\u0446) (\u043f\u0440\u0438 \u0438\u0445 \u043d\u0430\u043b\u0438\u0447\u0438\u0438) (H)")
    private String additionalInfo;

    public List<AwpSenderParticipantV1> getSenders() {
        return this.senders;
    }

    public void setSenders(List<AwpSenderParticipantV1> senders) {
        this.senders = senders;
    }

    public List<AwpRecipientParticipantV1> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<AwpRecipientParticipantV1> recipients) {
        this.recipients = recipients;
    }

    public AwpContractV1 getContract() {
        return this.contract;
    }

    public void setContract(AwpContractV1 contract) {
        this.contract = contract;
    }

    public AwpWorksPerformedV1 getWorksPerformed() {
        return this.worksPerformed;
    }

    public void setWorksPerformed(AwpWorksPerformedV1 worksPerformed) {
        this.worksPerformed = worksPerformed;
    }

    public String getAdditionalStock() {
        return this.additionalStock;
    }

    public void setAdditionalStock(String additionalStock) {
        this.additionalStock = additionalStock;
    }

    public String getAdditionalName() {
        return this.additionalName;
    }

    public void setAdditionalName(String additionalName) {
        this.additionalName = additionalName;
    }

    public String getAdditionalAppendix() {
        return this.additionalAppendix;
    }

    public void setAdditionalAppendix(String additionalAppendix) {
        this.additionalAppendix = additionalAppendix;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    @Override
    public String getCreatorTin() {
        List<AwpSenderParticipantV1> sellers = this.getSenders();
        if (sellers != null && !sellers.isEmpty() && sellers.get(0) != null) {
            return sellers.get(0).getTin();
        }
        return null;
    }

    @Override
    public void setOperatorFullname(String operatorFullname) throws Exception {
        throw new Exception("Realize operator");
    }

    @Override
    public List<String> getRecipientTinList() {
        ArrayList<String> list = new ArrayList<String>();
        List<AwpRecipientParticipantV1> recipients = this.getRecipients();
        if (recipients != null) {
            for (AwpRecipientParticipantV1 recipient : recipients) {
                if (recipient == null || recipient.getTin() == null) continue;
                list.add(recipient.getTin());
            }
        }
        return list;
    }

    @Override
    public List<String> getSenderTinList() {
        ArrayList<String> list = new ArrayList<String>();
        List<AwpSenderParticipantV1> senders = this.getSenders();
        if (senders != null) {
            for (AwpSenderParticipantV1 sender : senders) {
                if (sender == null || sender.getTin() == null) continue;
                list.add(sender.getTin());
            }
        }
        return list;
    }

    @Override
    public List<AbstractAwpParticipant> getParticipants() {
        ArrayList<AbstractAwpParticipant> participants = new ArrayList<AbstractAwpParticipant>();
        participants.addAll(this.senders);
        participants.addAll(this.recipients);
        return participants;
    }

    @Override
    public AbstractAwpParticipant getParticipantByTin(String tin) {
        Optional<AbstractAwpParticipant> oParticipant = this.getParticipants().stream().filter(p -> p.getTin().equals(tin)).findFirst();
        return oParticipant.orElse(null);
    }

    public AwpSenderParticipantV1 getSenderByTin(String tin) {
        Optional<AwpSenderParticipantV1> oParticipant = this.getSenders().stream().filter(p -> p.getTin().equals(tin)).findFirst();
        return oParticipant.orElse(null);
    }

    public AwpRecipientParticipantV1 getRecipientByTin(String tin) {
        Optional<AwpRecipientParticipantV1> oParticipant = this.getRecipients().stream().filter(p -> p.getTin().equals(tin)).findFirst();
        return oParticipant.orElse(null);
    }
}

