/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.dictionary;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections4.CollectionUtils;
import ru.uss.esf.model.isgo.IsgoSystemParam;
import ru.uss.esf.model.isgo.IsgoVshepType;
import ru.uss.esf.validation.common.field.Text;

@XmlType(name="IsgoSystem")
@XmlAccessorType(value=XmlAccessType.FIELD)
@Documentation(value="\u0418\u0421 \u0413\u041e")
public class IsgoSystem {
    @Text(min=1, max=50, message="{isgo.code.size}")
    @NotNull(message="{isgo.code.notNull}")
    @Documentation(value="\u041a\u043e\u0434")
    private @NotNull(message="{isgo.code.notNull}") String code;
    @Text(min=1, max=255, message="{isgo.nameRu.size}")
    @NotNull(message="{isgo.nameRu.notNull}")
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u0430 \u0440\u0443\u0441\u0441\u043a\u043e\u043c \u044f\u0437\u044b\u043a\u0435")
    private @NotNull(message="{isgo.nameRu.notNull}") String nameRu;
    @Text(min=1, max=255, message="{isgo.nameKz.size}")
    @NotNull(message="{isgo.nameKz.notNull}")
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u044f \u043d\u0430 \u043a\u0430\u0437\u0430\u0445\u0441\u043a\u043e\u043c \u044f\u0437\u044b\u043a\u0435")
    private @NotNull(message="{isgo.nameKz.notNull}") String nameKz;
    @NotNull(message="{isgo.vshepUserId.notNull}")
    @Documentation(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044f \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0428\u0415\u041f")
    private @NotNull(message="{isgo.vshepUserId.notNull}") String vshepUserId;
    @JsonIgnore
    @Documentation(value="\u041a\u043e\u0434 \u0441\u0435\u0440\u0432\u0438\u0441\u0430 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0428\u0415\u041f")
    private String vshepParamsJson;
    @XmlTransient
    @Documentation(value="\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043f\u043e\u0434\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u042d\u0421\u0424")
    private boolean needConfirmation;
    @Documentation(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0438 \u043f\u043e \u043f\u0440\u0438\u0447\u0438\u043d\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u044f \u0440\u0435\u0448\u0435\u043d\u0438\u044f \u043e \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438 \u0432 \u0437\u0430\u044f\u0432\u043a\u0443")
    private boolean decisionBlock;
    @Documentation(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0438 \u043f\u043e \u043f\u0440\u0438\u0447\u0438\u043d\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u044f \u0440\u0435\u0448\u0435\u043d\u0438\u044f \u043e \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u0438 \u0441\u0443\u0431\u0441\u0438\u0434\u0438\u0438")
    private boolean subsidyBlock;
    @Valid
    @NotNull(message="{isgo.vshepParams.notNull}")
    @Documentation(value="\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0428\u0415\u041f")
    private @Valid @NotNull(message="{isgo.vshepParams.notNull}") List<IsgoSystemParam> vshepParams;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getNameRu() {
        return this.nameRu;
    }

    public void setNameRu(String nameRu) {
        this.nameRu = nameRu;
    }

    public String getNameKz() {
        return this.nameKz;
    }

    public void setNameKz(String nameKz) {
        this.nameKz = nameKz;
    }

    public boolean isNeedConfirmation() {
        return this.needConfirmation;
    }

    public void setNeedConfirmation(boolean needConfirmation) {
        this.needConfirmation = needConfirmation;
    }

    public boolean isDecisionBlock() {
        return this.decisionBlock;
    }

    public void setDecisionBlock(boolean decisionBlock) {
        this.decisionBlock = decisionBlock;
    }

    public boolean isSubsidyBlock() {
        return this.subsidyBlock;
    }

    public void setSubsidyBlock(boolean subsidyBlock) {
        this.subsidyBlock = subsidyBlock;
    }

    public String getVshepParamsJson() {
        return this.vshepParamsJson;
    }

    public void setVshepParamsJson(String vshepParamsJson) {
        this.vshepParamsJson = vshepParamsJson;
    }

    public boolean isActive() {
        return !this.decisionBlock && !this.subsidyBlock;
    }

    public String getVshepUserId() {
        return this.vshepUserId;
    }

    public void setVshepUserId(String vshepUserId) {
        this.vshepUserId = vshepUserId;
    }

    public List<IsgoSystemParam> getVshepParams() {
        return this.vshepParams;
    }

    public void setVshepParams(List<IsgoSystemParam> vshepParams) {
        this.vshepParams = vshepParams;
    }

    public IsgoSystemParam getSystemInfo(IsgoVshepType vshepType) {
        return CollectionUtils.isNotEmpty(this.vshepParams) ? (IsgoSystemParam)this.vshepParams.stream().filter(param -> Objects.equals((Object)vshepType, (Object)param.getVshepType())).findAny().orElse(null) : null;
    }
}

