/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.dictionary;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.utils.LocaleUtils;
import ru.uss.esf.model.blocking.BlockingReason;
import ru.uss.esf.model.dictionary.EnterpriseState;
import ru.uss.esf.model.dictionary.EnterpriseType;
import ru.uss.esf.model.dictionary.SettlementAccount;
import ru.uss.esf.model.dictionary.TaxpayerAddress;
import ru.uss.esf.model.dictionary.TaxpayerRegistration;

@XmlType(name="Taxpayer")
@XmlAccessorType(value=XmlAccessType.FIELD)
@Documentation(value="\u041d\u0430\u043b\u043e\u0433\u043e\u043f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a")
public class Taxpayer
implements Serializable {
    @NotNull
    @Documentation(value="\u0418\u0418\u041d/\u0411\u0418\u041d")
    private String tin;
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u0430 \u0440\u0443\u0441\u0441\u043a\u043e\u043c \u044f\u0437\u044b\u043a\u0435")
    private String nameRu;
    @Documentation(value="\u0424\u0430\u043c\u0438\u043b\u0438\u044f \u043d\u0430 \u0440\u0443\u0441\u0441\u043a\u043e\u043c \u044f\u0437\u044b\u043a\u0435")
    private String lastNameRu;
    @Documentation(value="\u0418\u043c\u044f \u043d\u0430 \u0440\u0443\u0441\u0441\u043a\u043e\u043c \u044f\u0437\u044b\u043a\u0435")
    private String firstNameRu;
    @Documentation(value="\u041e\u0442\u0447\u0435\u0441\u0442\u0432\u043e \u043d\u0430 \u0440\u0443\u0441\u0441\u043a\u043e\u043c \u044f\u0437\u044b\u043a\u0435")
    private String middleNameRu;
    @Documentation(value="\u0424\u0430\u043c\u0438\u043b\u0438\u044f \u043d\u0430 \u043a\u0430\u0437\u0430\u0445\u0441\u043a\u043e\u043c \u044f\u0437\u044b\u043a\u0435")
    private String lastNameKz;
    @Documentation(value="\u0418\u043c\u044f \u043d\u0430 \u043a\u0430\u0437\u0430\u0445\u0441\u043a\u043e\u043c \u044f\u0437\u044b\u043a\u0435")
    private String firstNameKz;
    @Documentation(value="\u041e\u0442\u0447\u0435\u0441\u0442\u0432\u043e \u043d\u0430 \u043a\u0430\u0437\u0430\u0445\u0441\u043a\u043e\u043c \u044f\u0437\u044b\u043a\u0435")
    private String middleNameKz;
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u0430 \u043a\u0430\u0437\u0430\u0445\u0441\u043a\u043e\u043c \u044f\u0437\u044b\u043a\u0435")
    private String nameKz;
    @Documentation(value="\u0410\u0434\u0440\u0435\u0441 \u043d\u0430 \u0440\u0443\u0441\u0441\u043a\u043e\u043c \u044f\u0437\u044b\u043a\u0435")
    private String addressRu;
    @Documentation(value="\u0410\u0434\u0440\u0435\u0441 \u043d\u0430 \u043a\u0430\u0437\u0430\u0445\u0441\u043a\u043e\u043c \u044f\u0437\u044b\u043a\u0435")
    private String addressKz;
    @Documentation(value="\u0421\u0435\u0440\u0438\u044f \u0441\u0432\u0438\u0434\u0435\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0430 \u041d\u0414\u0421")
    private String certificateSeries;
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u0441\u0432\u0438\u0434\u0435\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0430 \u041d\u0414\u0421")
    private String certificateNum;
    @Documentation(value="\u042f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043b\u0438 \u043d\u0430\u043b\u043e\u0433\u043e\u043f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a \u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442\u043e\u043c")
    private boolean resident;
    @Documentation(value="\u0413\u043e\u043b\u043e\u0432\u043d\u043e\u0439 \u043e\u0444\u0438\u0441 \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u044f")
    private Taxpayer headOffice;
    @Documentation(value="\u0422\u0438\u043f \u043d\u0430\u043b\u043e\u0433\u043e\u043f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0430")
    private EnterpriseType type = EnterpriseType.NOT_SET;
    @XmlTransient
    private EnterpriseState state = EnterpriseState.NOT_SET;
    @XmlTransient
    private BlockingReason blockingReason;
    @Documentation(value="\u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0435 \u0442\u0438\u043f\u044b \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430 \u041d\u041f")
    @XmlTransient
    private Set<TaxpayerRegistration.Type> registrationTypes = new HashSet<TaxpayerRegistration.Type>();
    @Documentation(value="\u0410\u0434\u0440\u0435\u0441\u0430 \u043f\u043e \u0442\u0438\u043f\u0430\u043c \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430 \u041d\u041f")
    @XmlTransient
    private Set<TaxpayerAddress> taxpayerAddresses = new HashSet<TaxpayerAddress>();
    private boolean resourceUser;
    @XmlElementWrapper
    @XmlElement(name="settlementAccount")
    @Documentation(value="\u0411\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0441\u0447\u0435\u0442")
    private List<SettlementAccount> accounts = new ArrayList<SettlementAccount>();
    @Documentation(value="\u0418\u0418\u041d \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0430 \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u044f")
    private String enterpriseAdministrator;
    @Documentation(value="\u0418\u0418\u041d \u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0433\u043e \u0440\u0430\u0431\u043e\u0442\u043d\u0438\u043a\u0430 \u043f\u043e \u0440\u0430\u0441\u0447\u0435\u0442\u0430\u043c \u0441 \u0431\u044e\u0434\u0436\u0435\u0442\u043e\u043c \u042e\u041b")
    private String budgetIin;
    @Documentation(value="\u041a\u043e\u0434 \u043e\u0440\u0433\u0430\u043d\u0430 \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0434\u043e\u0445\u043e\u0434\u043e\u0432")
    private String kogd;
    @XmlTransient
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0437\u0430\u043f\u0438\u0441\u0438")
    private Date createdDate;
    @XmlTransient
    @Documentation(value="\u0414\u0430\u0442\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0437\u0430\u043f\u0438\u0441\u0438")
    private Date updatedDate;
    @XmlTransient
    @Documentation(value="\u0411\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044c \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432, \u043a\u0430\u043a \u0424\u041b")
    private boolean isBlockedAsIndividual;
    @XmlTransient
    @Documentation(value="\u0411\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u0430\u043a \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044c \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432, \u043a\u0430\u043a \u041f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u0435 \u0438\u043b\u0438 \u0418\u041f")
    private boolean isBlockedAsEnterprise;

    public String getPreferableUserName(Locale locale) {
        String firstName = LocaleUtils.getPreferable(locale, this.getFirstNameRu(), this.getFirstNameKz());
        String lastName = LocaleUtils.getPreferable(locale, this.getLastNameRu(), this.getLastNameKz());
        String middleName = LocaleUtils.getPreferable(locale, this.getMiddleNameRu(), this.getMiddleNameKz());
        return String.format("%s %s %s", lastName, firstName, middleName).trim();
    }

    public String getPreferableCompanyName(Locale locale) {
        return LocaleUtils.getPreferable(locale, this.getNameRu(), this.getNameKz());
    }

    public String getPreferableName(Locale locale) {
        String userName = this.getPreferableUserName(locale);
        return userName.isEmpty() ? this.getPreferableCompanyName(locale) : userName;
    }

    public String getPreferableAddress(Locale locale) {
        return LocaleUtils.getPreferable(locale, this.getAddressRu(), this.getAddressKz());
    }

    public String getTin() {
        return this.tin;
    }

    public void setTin(String tin) {
        this.tin = tin;
    }

    public String getNameRu() {
        return this.nameRu;
    }

    public void setNameRu(String nameRu) {
        this.nameRu = nameRu;
    }

    public String getNameKz() {
        return this.nameKz;
    }

    public void setNameKz(String nameKz) {
        this.nameKz = nameKz;
    }

    public String getFirstNameRu() {
        return this.firstNameRu;
    }

    public void setFirstNameRu(String firstNameRu) {
        this.firstNameRu = firstNameRu;
    }

    public String getLastNameRu() {
        return this.lastNameRu;
    }

    public void setLastNameRu(String lastNameRu) {
        this.lastNameRu = lastNameRu;
    }

    public String getMiddleNameRu() {
        return this.middleNameRu;
    }

    public void setMiddleNameRu(String middleNameRu) {
        this.middleNameRu = middleNameRu;
    }

    public String getLastNameKz() {
        return this.lastNameKz;
    }

    public void setLastNameKz(String lastNameKz) {
        this.lastNameKz = lastNameKz;
    }

    public String getFirstNameKz() {
        return this.firstNameKz;
    }

    public void setFirstNameKz(String firstNameKz) {
        this.firstNameKz = firstNameKz;
    }

    public String getMiddleNameKz() {
        return this.middleNameKz;
    }

    public void setMiddleNameKz(String middleNameKz) {
        this.middleNameKz = middleNameKz;
    }

    public String getAddressRu() {
        return this.addressRu;
    }

    public void setAddressRu(String addressRu) {
        this.addressRu = addressRu;
    }

    public String getAddressKz() {
        return this.addressKz;
    }

    public void setAddressKz(String addressKz) {
        this.addressKz = addressKz;
    }

    public String getCertificateSeries() {
        return this.certificateSeries;
    }

    public void setCertificateSeries(String certificateSeries) {
        this.certificateSeries = certificateSeries;
    }

    public String getCertificateNum() {
        return this.certificateNum;
    }

    public void setCertificateNum(String certificateNum) {
        this.certificateNum = certificateNum;
    }

    public boolean isCertificateNotEmpty() {
        return StringUtils.isNotEmpty((CharSequence)this.getCertificateNum()) && StringUtils.isNotEmpty((CharSequence)this.getCertificateSeries());
    }

    public boolean isResident() {
        return this.resident;
    }

    public void setResident(boolean resident) {
        this.resident = resident;
    }

    public EnterpriseType getType() {
        return this.type;
    }

    public void setType(EnterpriseType type) {
        this.type = type;
    }

    public EnterpriseState getState() {
        return this.state;
    }

    public void setState(EnterpriseState state) {
        this.state = state;
    }

    public boolean isResourceUser() {
        return this.resourceUser;
    }

    public void setResourceUser(boolean resourceUser) {
        this.resourceUser = resourceUser;
    }

    public List<SettlementAccount> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<SettlementAccount> accounts) {
        this.accounts = accounts;
    }

    public Taxpayer getHeadOffice() {
        return this.headOffice;
    }

    public void setHeadOffice(Taxpayer headOffice) {
        this.headOffice = headOffice;
    }

    public String getHeadOfficeTin() {
        return this.getHeadOffice() == null ? null : this.getHeadOffice().getTin();
    }

    public boolean hasHeadOffice() {
        return this.getHeadOffice() != null;
    }

    public String getEnterpriseAdministrator() {
        return this.enterpriseAdministrator;
    }

    public void setEnterpriseAdministrator(String enterpriseAdministrator) {
        this.enterpriseAdministrator = enterpriseAdministrator;
    }

    public String getBudgetIin() {
        return this.budgetIin;
    }

    public void setBudgetIin(String budgetIin) {
        this.budgetIin = budgetIin;
    }

    public String getKogd() {
        return this.kogd;
    }

    public void setKogd(String kogd) {
        this.kogd = kogd;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate;
    }

    public boolean isFakeEnterprise() {
        return this.getState() == EnterpriseState.FAKE;
    }

    public boolean isIndividual() {
        return EnterpriseType.INDIVIDUAL.equals((Object)this.getType());
    }

    public boolean isEntrepreneur() {
        return EnterpriseType.INDIVIDUAL_ENTREPRENEUR.equals((Object)this.getType());
    }

    public boolean isEnterprise() {
        return this.type == EnterpriseType.PRIVATE_ENTERPRISE || this.type == EnterpriseType.STATE_ENTERPRISE;
    }

    public BlockingReason getBlockingReason() {
        return this.blockingReason;
    }

    public void setBlockingReason(BlockingReason blockingReason) {
        this.blockingReason = blockingReason;
    }

    public Set<TaxpayerRegistration.Type> getRegistrationTypes() {
        return this.registrationTypes;
    }

    public void setRegistrationTypes(Set<TaxpayerRegistration.Type> registrationTypes) {
        this.registrationTypes = registrationTypes;
    }

    public String resolveBudgetIin() {
        return this.budgetIin != null ? this.budgetIin : this.enterpriseAdministrator;
    }

    public boolean isBlockedAsIndividual() {
        return this.isBlockedAsIndividual;
    }

    public boolean isBlockedAsEnterprise() {
        return this.isBlockedAsEnterprise;
    }

    public void setBlockedAsIndividual(boolean blockedAsIndividual) {
        this.isBlockedAsIndividual = blockedAsIndividual;
    }

    public void setBlockedAsEnterprise(boolean blockedAsEnterprise) {
        this.isBlockedAsEnterprise = blockedAsEnterprise;
    }

    public boolean isBlocked() {
        return this.blockingReason != null && this.blockingReason.getAcceptableEnterpriseTypes().contains((Object)this.type);
    }

    public static void removePrivateInfo(Taxpayer taxpayer) {
        if (taxpayer != null) {
            taxpayer.setAccounts(null);
            taxpayer.setAddressKz(null);
            taxpayer.setAddressRu(null);
        }
    }

    public Set<TaxpayerAddress> getTaxpayerAddresses() {
        return this.taxpayerAddresses;
    }

    public void setTaxpayerAddresses(Set<TaxpayerAddress> taxpayerAddresses) {
        this.taxpayerAddresses = taxpayerAddresses;
    }

    @JsonProperty(value="addressesByRegType", access=JsonProperty.Access.READ_ONLY)
    public Map<TaxpayerRegistration.Type, Map<String, String>> addressesByRegType() {
        return this.taxpayerAddresses.stream().collect(Collectors.toMap(TaxpayerAddress::getType, taxpayerAddress -> ImmutableMap.of((Object)"ru", (Object)taxpayerAddress.getAddressRu(), (Object)"kz", (Object)taxpayerAddress.getAddressKz())));
    }

    public String getFilledName() {
        String name = this.getNameRu();
        if (name == null) {
            name = this.getNameKz();
        }
        if (name == null) {
            name = StringUtils.defaultString((String)this.getFirstNameRu(), (String)"") + " " + StringUtils.defaultString((String)this.getMiddleNameRu(), (String)"") + " " + StringUtils.defaultString((String)this.getLastNameRu(), (String)"");
        }
        if (StringUtils.isBlank((CharSequence)name.trim())) {
            name = StringUtils.defaultString((String)this.getFirstNameKz(), (String)"") + " " + StringUtils.defaultString((String)this.getMiddleNameKz(), (String)"") + " " + StringUtils.defaultString((String)this.getLastNameKz(), (String)"");
        }
        return name;
    }
}

