/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.econtract;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import ru.uss.esf.model.econtract.EcontractParticipantType;
import ru.uss.esf.model.econtract.EcontractStatus;

public class EcontractStatusChangeProcessingInfo {
    private EcontractStatus previousStatus;
    private EcontractStatus nextStatus;
    private String notificationType;
    private EnumSet<EcontractParticipantType> notificationRecipients;
    private Set<StatusChangeProcessingFlag> flags;

    public EcontractStatusChangeProcessingInfo(EcontractStatus previousStatus, EcontractStatus nextStatus) {
        this.previousStatus = previousStatus;
        this.nextStatus = nextStatus;
        this.flags = new HashSet<StatusChangeProcessingFlag>();
    }

    public EcontractStatus getPreviousStatus() {
        return this.previousStatus;
    }

    public EcontractStatus getNextStatus() {
        return this.nextStatus;
    }

    public EcontractStatusChangeProcessingInfo enableAddDeadlineControl() {
        this.flags.add(StatusChangeProcessingFlag.ADD_DEADLINE_CONTROL);
        return this;
    }

    public EcontractStatusChangeProcessingInfo enableDeleteDeadlineControl() {
        this.flags.add(StatusChangeProcessingFlag.DELETE_DEADLINE_CONTROL);
        return this;
    }

    public EcontractStatusChangeProcessingInfo enableResetParticipantStatus() {
        this.flags.add(StatusChangeProcessingFlag.RESET_PARTICIPANT_STATUS);
        return this;
    }

    public EcontractStatusChangeProcessingInfo enableProcessCessionOfRights() {
        this.flags.add(StatusChangeProcessingFlag.PROCESS_CESSION_OF_RIGHTS);
        return this;
    }

    public EcontractStatusChangeProcessingInfo enableUpdateRelatedEcontracts() {
        this.flags.add(StatusChangeProcessingFlag.UPDATE_RELATED_ECONTRACTS);
        return this;
    }

    public EcontractStatusChangeProcessingInfo enableOpenAccessToOtherParty() {
        this.flags.add(StatusChangeProcessingFlag.OPEN_ACCESS_TO_OTHER_PARTY);
        return this;
    }

    public EcontractStatusChangeProcessingInfo enableSendNotification() {
        this.flags.add(StatusChangeProcessingFlag.SEND_NOTIFIICATION);
        return this;
    }

    public EcontractStatusChangeProcessingInfo enableUpdateTermsOfParentEcontract() {
        this.flags.add(StatusChangeProcessingFlag.UPDATE_TERMS_OF_PARENT_ECONTRACT);
        return this;
    }

    public EcontractStatusChangeProcessingInfo setNotificationType(String notificationType) {
        this.notificationType = notificationType;
        return this;
    }

    public EcontractStatusChangeProcessingInfo addNotificationRecipient(EcontractParticipantType recipient) {
        if (CollectionUtils.isEmpty(this.notificationRecipients)) {
            this.notificationRecipients = EnumSet.noneOf(EcontractParticipantType.class);
        }
        this.notificationRecipients.add(recipient);
        return this;
    }

    public EcontractStatusChangeProcessingInfo addNotificationRecipients(EcontractParticipantType ... recipient) {
        if (recipient != null && recipient.length > 0) {
            for (EcontractParticipantType type : recipient) {
                this.addNotificationRecipient(type);
            }
        }
        return this;
    }

    public boolean needAddDeadlineControl() {
        return this.flags.contains((Object)StatusChangeProcessingFlag.ADD_DEADLINE_CONTROL);
    }

    public boolean needDeleteDeadlineControl() {
        return this.flags.contains((Object)StatusChangeProcessingFlag.DELETE_DEADLINE_CONTROL);
    }

    public boolean needResetParticipantStatus() {
        return this.flags.contains((Object)StatusChangeProcessingFlag.RESET_PARTICIPANT_STATUS);
    }

    public boolean needOpenAccessToOtherParty() {
        return this.flags.contains((Object)StatusChangeProcessingFlag.OPEN_ACCESS_TO_OTHER_PARTY);
    }

    public boolean needProcessCessionOfRights() {
        return this.flags.contains((Object)StatusChangeProcessingFlag.PROCESS_CESSION_OF_RIGHTS);
    }

    public boolean needUpdateRelatedEcontracts() {
        return this.flags.contains((Object)StatusChangeProcessingFlag.UPDATE_RELATED_ECONTRACTS);
    }

    public boolean needSendNotification() {
        return this.flags.contains((Object)StatusChangeProcessingFlag.SEND_NOTIFIICATION);
    }

    public boolean needUpdateTermsOfParentEcontract() {
        return this.flags.contains((Object)StatusChangeProcessingFlag.UPDATE_TERMS_OF_PARENT_ECONTRACT);
    }

    public String getNotificationType() {
        return this.notificationType;
    }

    public EcontractParticipantType[] getNotificationRecipients() {
        return this.notificationRecipients.toArray(new EcontractParticipantType[0]);
    }

    private static enum StatusChangeProcessingFlag {
        ADD_DEADLINE_CONTROL,
        DELETE_DEADLINE_CONTROL,
        SEND_TO_EHD,
        RESET_PARTICIPANT_STATUS,
        SEND_NOTIFIICATION,
        PROCESS_CESSION_OF_RIGHTS,
        UPDATE_RELATED_ECONTRACTS,
        OPEN_ACCESS_TO_OTHER_PARTY,
        UPDATE_TERMS_OF_PARENT_ECONTRACT;

    }
}

