/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.econtract.version.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections4.CollectionUtils;
import ru.uss.core.validation.common.ContinuousNumbering;
import ru.uss.core.validation.common.IsNotNull;
import ru.uss.core.validation.common.IsNull;
import ru.uss.esf.model.econtract.abstractecontract.AbstractEcontract;
import ru.uss.esf.model.econtract.abstractecontract.AbstractEcontractParticipant;
import ru.uss.esf.model.econtract.version.v1.EcontractCommissionFeeV1;
import ru.uss.esf.model.econtract.version.v1.EcontractCurrencyV1;
import ru.uss.esf.model.econtract.version.v1.EcontractCustomerV1;
import ru.uss.esf.model.econtract.version.v1.EcontractPaymentMethodV1;
import ru.uss.esf.model.econtract.version.v1.EcontractPaymentProcedureV1;
import ru.uss.esf.model.econtract.version.v1.EcontractPaymentScheduleV1;
import ru.uss.esf.model.econtract.version.v1.EcontractPowerOfAttorneyV1;
import ru.uss.esf.model.econtract.version.v1.EcontractSpecificationV1;
import ru.uss.esf.model.econtract.version.v1.EcontractStageV1;
import ru.uss.esf.model.econtract.version.v1.EcontractSubjectV1;
import ru.uss.esf.model.econtract.version.v1.EcontractSupplierV1;
import ru.uss.esf.validation.common.field.Text;
import ru.uss.esf.validation.econtract.EcontractValidationGroups;
import ru.uss.esf.validation.econtract.version.v1.CorrectEcontractTermsV1;
import ru.uss.esf.validation.econtract.version.v1.EcontractCurrencyConsistencyV1;
import ru.uss.esf.validation.econtract.version.v1.NonDuplicateParticipantV1;
import ru.uss.esf.validation.econtract.version.v1.ParticipantCountV1;
import ru.uss.esf.validation.econtract.version.v1.PresenceOfProductCurrencyCodeForMultiCurrencyEcontractV1;
import ru.uss.esf.validation.econtract.version.v1.PresenceOfSuccessorsV1;
import ru.uss.esf.validation.econtract.version.v1.StageImplementationDeadlineOrderV1;

@CorrectEcontractTermsV1
@PresenceOfProductCurrencyCodeForMultiCurrencyEcontractV1
@EcontractCurrencyConsistencyV1
@NonDuplicateParticipantV1
@PresenceOfSuccessorsV1
@ParticipantCountV1(groups={EcontractValidationGroups.JointGwsProcurement.class})
@StageImplementationDeadlineOrderV1(groups={EcontractValidationGroups.GwsProcurement.class, EcontractValidationGroups.JointGwsProcurement.class})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="econtract")
@XmlType(name="EcontractV1")
@Documentation(value="\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0432\u0435\u0440\u0441\u0438\u0438 1")
public class EcontractV1
extends AbstractEcontract {
    @IsNotNull(fieldPath="econtract.numberFromAccountingSystem")
    @Text(min=1, max=255, message="{econtract.numberFromAccountingSystem.size}")
    @XmlElement(required=true)
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0438\u0437 \u0443\u0447\u0435\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u044b")
    private String numberFromAccountingSystem;
    @IsNull(fieldPath="econtract.paymentMethod", groups={EcontractValidationGroups.Leasing.class})
    @XmlElement(required=false)
    @Documentation(value="\u0421\u043f\u043e\u0441\u043e\u0431 \u043e\u043f\u043b\u0430\u0442\u044b")
    private EcontractPaymentMethodV1 paymentMethod;
    @IsNotNull(fieldPath="econtract.unilateralTermination")
    @XmlElement(required=true)
    @Documentation(value="\u0420\u0430\u0441\u0442\u043e\u0440\u0436\u0435\u043d\u0438\u0435 \u0432 \u043e\u0434\u043d\u043e\u0441\u0442\u043e\u0440\u043e\u043d\u043d\u0435\u043c \u043f\u043e\u0440\u044f\u0434\u043a\u0435")
    private Boolean unilateralTermination;
    @Valid
    @NotNull(message="{econtract.currency.notNull}")
    @XmlElement(required=true)
    @Documentation(value="\u0412\u0430\u043b\u044e\u0442\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430")
    private @Valid @NotNull(message="{econtract.currency.notNull}") EcontractCurrencyV1 currency;
    @Valid
    @ContinuousNumbering(fieldPath="econtract.suppliers")
    @IsNotNull(fieldPath="econtract.suppliers")
    @Size.List(value={@Size(min=1, max=1, message="{econtract.suppliers.size.one}", groups={EcontractValidationGroups.GwsProcurement.class, EcontractValidationGroups.Leasing.class}), @Size(min=1, message="{econtract.suppliers.size}", groups={EcontractValidationGroups.JointGwsProcurement.class, EcontractValidationGroups.TransportExpedition.class, EcontractValidationGroups.Commission.class, EcontractValidationGroups.Assignment.class, EcontractValidationGroups.CessionOfRights.class, EcontractValidationGroups.Supplementary.class})})
    @XmlElementWrapper
    @XmlElement(required=true, name="supplier")
    @Documentation(value="\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0438 (B)")
    private @Valid @Size.List(value={@Size(min=1, max=1, message="{econtract.suppliers.size.one}", groups={EcontractValidationGroups.GwsProcurement.class, EcontractValidationGroups.Leasing.class}), @Size(min=1, message="{econtract.suppliers.size}", groups={EcontractValidationGroups.JointGwsProcurement.class, EcontractValidationGroups.TransportExpedition.class, EcontractValidationGroups.Commission.class, EcontractValidationGroups.Assignment.class, EcontractValidationGroups.CessionOfRights.class, EcontractValidationGroups.Supplementary.class})}) List<EcontractSupplierV1> suppliers;
    @Valid
    @ContinuousNumbering(fieldPath="econtract.customers")
    @IsNotNull(fieldPath="econtract.customers")
    @Size.List(value={@Size(min=1, max=1, message="{econtract.customers.size.one}", groups={EcontractValidationGroups.GwsProcurement.class, EcontractValidationGroups.Leasing.class}), @Size(min=1, message="{econtract.customers.size}", groups={EcontractValidationGroups.JointGwsProcurement.class, EcontractValidationGroups.TransportExpedition.class, EcontractValidationGroups.Commission.class, EcontractValidationGroups.Assignment.class, EcontractValidationGroups.CessionOfRights.class, EcontractValidationGroups.Supplementary.class})})
    @XmlElementWrapper
    @XmlElement(required=true, name="customer")
    @Documentation(value="\u041f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u0438 (C)")
    private @Valid @Size.List(value={@Size(min=1, max=1, message="{econtract.customers.size.one}", groups={EcontractValidationGroups.GwsProcurement.class, EcontractValidationGroups.Leasing.class}), @Size(min=1, message="{econtract.customers.size}", groups={EcontractValidationGroups.JointGwsProcurement.class, EcontractValidationGroups.TransportExpedition.class, EcontractValidationGroups.Commission.class, EcontractValidationGroups.Assignment.class, EcontractValidationGroups.CessionOfRights.class, EcontractValidationGroups.Supplementary.class})}) List<EcontractCustomerV1> customers;
    @Valid
    @XmlElementWrapper
    @XmlElement(required=false, name="supplierSuccessor")
    @Documentation(value="\u041f\u0440\u0430\u0432\u043e\u043f\u0440\u0435\u0435\u043c\u043d\u0438\u043a\u0438 \u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u043e\u0432 (B)")
    private List<EcontractSupplierV1> supplierSuccessors;
    @Valid
    @XmlElementWrapper
    @XmlElement(required=false, name="customerSuccessor")
    @Documentation(value="\u041f\u0440\u0430\u0432\u043e\u043f\u0440\u0435\u0435\u043c\u043d\u0438\u043a\u0438 \u041f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u0435\u0439 (C)")
    private List<EcontractCustomerV1> customerSuccessors;
    @Valid
    @XmlElement
    @Documentation(value="\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0434\u043e\u0432\u0435\u0440\u0435\u043d\u043d\u043e\u0441\u0442\u0438 (D)")
    private EcontractPowerOfAttorneyV1 powerOfAttorney;
    @XmlElement
    @Documentation(value="\u0423\u0441\u043b\u043e\u0432\u0438\u044f \u043e\u043f\u043b\u0430\u0442\u044b \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443")
    private String termsOfPayment;
    @XmlElement
    @Documentation(value="\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435")
    private String comment;
    @IsNull(fieldPath="econtract.commissionFee", groups={EcontractValidationGroups.GwsProcurement.class, EcontractValidationGroups.JointGwsProcurement.class, EcontractValidationGroups.TransportExpedition.class, EcontractValidationGroups.Assignment.class})
    @IsNotNull(fieldPath="econtract.commissionFee", groups={EcontractValidationGroups.Commission.class})
    @XmlElement(required=false)
    @Documentation(value="\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u043e\u043d\u043d\u043e\u0435 \u0432\u043e\u0437\u043d\u0430\u0433\u0440\u0430\u0436\u0434\u0435\u043d\u0438\u0435")
    private EcontractCommissionFeeV1 commissionFee;
    @IsNull(fieldPath="econtract.paymentProcedure", groups={EcontractValidationGroups.GwsProcurement.class, EcontractValidationGroups.JointGwsProcurement.class, EcontractValidationGroups.TransportExpedition.class, EcontractValidationGroups.Commission.class, EcontractValidationGroups.Leasing.class})
    @IsNotNull(fieldPath="econtract.paymentProcedure", groups={EcontractValidationGroups.Assignment.class})
    @XmlElement(required=false)
    @Documentation(value="\u041f\u043e\u0440\u044f\u0434\u043e\u043a \u043e\u043f\u043b\u0430\u0442\u044b")
    private EcontractPaymentProcedureV1 paymentProcedure;
    @IsNull(fieldPath="econtract.econtractSubject", groups={EcontractValidationGroups.GwsProcurement.class, EcontractValidationGroups.JointGwsProcurement.class})
    @IsNotNull(fieldPath="econtract.econtractSubject", groups={EcontractValidationGroups.TransportExpedition.class, EcontractValidationGroups.Commission.class, EcontractValidationGroups.Assignment.class})
    @XmlElement(required=false)
    @Documentation(value="\u041f\u0440\u0435\u0434\u043c\u0435\u0442 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430")
    private EcontractSubjectV1 econtractSubject;
    @Valid
    @IsNull(fieldPath="econtract.stages", groups={EcontractValidationGroups.Leasing.class})
    @IsNotNull(fieldPath="econtract.stages", groups={EcontractValidationGroups.GwsProcurement.class, EcontractValidationGroups.JointGwsProcurement.class})
    @Size(min=1, message="{econtract.stages.size}", groups={EcontractValidationGroups.GwsProcurement.class, EcontractValidationGroups.JointGwsProcurement.class})
    @XmlElementWrapper
    @XmlElement(name="stage")
    @Documentation(value="\u042d\u0442\u0430\u043f\u044b (D)")
    private @Valid @Size(min=1, message="{econtract.stages.size}", groups={EcontractValidationGroups.GwsProcurement.class, EcontractValidationGroups.JointGwsProcurement.class}) List<EcontractStageV1> stages;
    @Valid
    @IsNull(fieldPath="econtract.specifications", groups={EcontractValidationGroups.GwsProcurement.class, EcontractValidationGroups.JointGwsProcurement.class, EcontractValidationGroups.TransportExpedition.class, EcontractValidationGroups.Commission.class, EcontractValidationGroups.Assignment.class})
    @IsNotNull(fieldPath="econtract.specifications", groups={EcontractValidationGroups.Leasing.class})
    @Size(min=1, message="{econtract.specifications.size}", groups={EcontractValidationGroups.Leasing.class})
    @XmlElement
    @Documentation(value="\u0421\u043f\u0435\u0446\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 (D)")
    private @Valid @Size(min=1, message="{econtract.specifications.size}", groups={EcontractValidationGroups.Leasing.class}) List<EcontractSpecificationV1> specifications;
    @Valid
    @IsNull(fieldPath="econtract.paymentSchedule", groups={EcontractValidationGroups.GwsProcurement.class, EcontractValidationGroups.JointGwsProcurement.class, EcontractValidationGroups.TransportExpedition.class, EcontractValidationGroups.Commission.class, EcontractValidationGroups.Assignment.class})
    @IsNotNull(fieldPath="econtract.paymentSchedule", groups={EcontractValidationGroups.Leasing.class})
    @XmlElement
    @Documentation(value="\u0413\u0440\u0430\u0444\u0438\u043a \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 (D)")
    private EcontractPaymentScheduleV1 paymentSchedule;

    public String getNumberFromAccountingSystem() {
        return this.numberFromAccountingSystem;
    }

    public void setNumberFromAccountingSystem(String numberFromAccountingSystem) {
        this.numberFromAccountingSystem = numberFromAccountingSystem;
    }

    public Boolean getUnilateralTermination() {
        return this.unilateralTermination;
    }

    public void setUnilateralTermination(Boolean unilateralTermination) {
        this.unilateralTermination = unilateralTermination;
    }

    public List<EcontractSupplierV1> getSuppliers() {
        return this.suppliers;
    }

    public void setSuppliers(List<EcontractSupplierV1> suppliers) {
        this.suppliers = suppliers;
    }

    public List<EcontractCustomerV1> getCustomers() {
        return this.customers;
    }

    public void setCustomers(List<EcontractCustomerV1> customers) {
        this.customers = customers;
    }

    public List<EcontractSupplierV1> getSupplierSuccessors() {
        return this.supplierSuccessors;
    }

    public void setSupplierSuccessors(List<EcontractSupplierV1> supplierSuccessors) {
        this.supplierSuccessors = supplierSuccessors;
    }

    public List<EcontractCustomerV1> getCustomerSuccessors() {
        return this.customerSuccessors;
    }

    public void setCustomerSuccessors(List<EcontractCustomerV1> customerSuccessors) {
        this.customerSuccessors = customerSuccessors;
    }

    public EcontractPowerOfAttorneyV1 getPowerOfAttorney() {
        return this.powerOfAttorney;
    }

    public void setPowerOfAttorney(EcontractPowerOfAttorneyV1 powerOfAttorney) {
        this.powerOfAttorney = powerOfAttorney;
    }

    public String getTermsOfPayment() {
        return this.termsOfPayment;
    }

    public void setTermsOfPayment(String termsOfPayment) {
        this.termsOfPayment = termsOfPayment;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setStages(List<EcontractStageV1> stages) {
        this.stages = stages;
    }

    public void setSpecifications(List<EcontractSpecificationV1> specifications) {
        this.specifications = specifications;
    }

    public EcontractPaymentScheduleV1 getPaymentSchedule() {
        return this.paymentSchedule;
    }

    public void setPaymentSchedule(EcontractPaymentScheduleV1 paymentSchedule) {
        this.paymentSchedule = paymentSchedule;
    }

    public EcontractPaymentMethodV1 getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(EcontractPaymentMethodV1 paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public EcontractCommissionFeeV1 getCommissionFee() {
        return this.commissionFee;
    }

    public void setCommissionFee(EcontractCommissionFeeV1 commissionFee) {
        this.commissionFee = commissionFee;
    }

    public EcontractPaymentProcedureV1 getPaymentProcedure() {
        return this.paymentProcedure;
    }

    public void setPaymentProcedure(EcontractPaymentProcedureV1 paymentProcedure) {
        this.paymentProcedure = paymentProcedure;
    }

    public EcontractSubjectV1 getEcontractSubject() {
        return this.econtractSubject;
    }

    public void setEcontractSubject(EcontractSubjectV1 econtractSubject) {
        this.econtractSubject = econtractSubject;
    }

    public EcontractCurrencyV1 getCurrency() {
        return this.currency;
    }

    public void setCurrency(EcontractCurrencyV1 currency) {
        this.currency = currency;
    }

    public String getCurrencyCode() {
        return this.getCurrency() != null ? this.getCurrency().getCurrencyCode() : null;
    }

    public List<EcontractStageV1> getStages() {
        return this.stages;
    }

    public List<EcontractSpecificationV1> getSpecifications() {
        return this.specifications;
    }

    @Override
    public List<AbstractEcontractParticipant> getParticipants() {
        ArrayList<AbstractEcontractParticipant> result = new ArrayList<AbstractEcontractParticipant>();
        result.addAll(Optional.ofNullable(this.suppliers).orElse(Collections.emptyList()));
        result.addAll(Optional.ofNullable(this.supplierSuccessors).orElse(Collections.emptyList()));
        result.addAll(Optional.ofNullable(this.customers).orElse(Collections.emptyList()));
        result.addAll(Optional.ofNullable(this.customerSuccessors).orElse(Collections.emptyList()));
        return result;
    }

    @Override
    public List<String> getCustomerTinList() {
        return Optional.ofNullable(this.getCustomers()).orElse(Collections.emptyList()).stream().filter(sender -> sender != null && sender.getTin() != null && !sender.getTin().isEmpty()).sorted((a, b) -> a.getNumber().compareTo(b.getNumber())).map(sender -> sender.getTin()).collect(Collectors.toList());
    }

    @Override
    public List<String> getSupplierTinList() {
        return Optional.ofNullable(this.getSuppliers()).orElse(Collections.emptyList()).stream().filter(supplier -> supplier != null && supplier.getTin() != null && !supplier.getTin().isEmpty()).map(supplier -> supplier.getTin()).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public Map<AbstractEcontractParticipant, AbstractEcontractParticipant> getSuccessorByPredecessor() {
        AbstractEcontractParticipant predecessor;
        HashMap<AbstractEcontractParticipant, AbstractEcontractParticipant> successorsByPredecessor = new HashMap<AbstractEcontractParticipant, AbstractEcontractParticipant>();
        if (!CollectionUtils.isEmpty(this.getSupplierSuccessors())) {
            for (AbstractEcontractParticipant abstractEcontractParticipant : this.getSupplierSuccessors()) {
                predecessor = this.getSuppliers().stream().filter(p -> p.getNumber().equals(successor.getNumber())).findFirst().get();
                successorsByPredecessor.put(predecessor, abstractEcontractParticipant);
            }
        }
        if (!CollectionUtils.isEmpty(this.getCustomerSuccessors())) {
            for (AbstractEcontractParticipant abstractEcontractParticipant : this.getCustomerSuccessors()) {
                predecessor = this.getCustomers().stream().filter(p -> p.getNumber().equals(successor.getNumber())).findFirst().get();
                successorsByPredecessor.put(predecessor, abstractEcontractParticipant);
            }
        }
        return successorsByPredecessor;
    }
}

