/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.egp.contract;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="EgpContractStatus")
@Documentation(value="\u0421\u0442\u0430\u0442\u0443\u0441 \u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u042d\u0413\u0417")
public enum EgpContractStatus {
    VALID("\u0414\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442", 190L),
    CHANGED("\u0418\u0437\u043c\u0435\u043d\u0435\u043d", 455L),
    PERFORMED("\u0418\u0441\u043f\u043e\u043b\u043d\u0435\u043d", 390L),
    NOT_CONCLUDED("\u041d\u0435 \u0437\u0430\u043a\u043b\u044e\u0447\u0435\u043d", 330L),
    SUPP_CREATED("\u0421\u043e\u0437\u0434\u0430\u043d\u043e \u0434\u043e\u043f.\u0441\u043e\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u0435", 450L),
    TERMINATED_UNILATERALLY("\u0420\u0430\u0441\u0442\u043e\u0440\u0433\u043d\u0443\u0442 \u0432 \u043e\u0434\u043d\u043e\u0441\u0442\u043e\u0440\u043e\u043d\u043d\u0435\u043c \u043f\u043e\u0440\u044f\u0434\u043a\u0435", 340L),
    PARTLY_PERFORMED("\u0427\u0430\u0441\u0442\u0438\u0447\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d", 375L),
    WAITING_FOR_TERMINATION("\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u0440\u0430\u0441\u0442\u043e\u0440\u0436\u0435\u043d\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", 345L),
    TRANSFER_OF_RIGHTS("\u041f\u0435\u0440\u0435\u0434\u0430\u0447\u0430 \u043f\u0440\u0430\u0432", 456L),
    VALID_TRANSFERED("\u041f\u0435\u0440\u0435\u0434\u0430\u043d.\u0414\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442", 460L),
    NOT_FOUND("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", 0L);

    private final String egpName;
    private final Long id;
    public static final List<EgpContractStatus> PROHIBITED_STATUSES;
    public static final List<EgpContractStatus> VALID_STATUSES;

    private EgpContractStatus(String name, Long id) {
        this.id = id;
        this.egpName = name;
    }

    public String getEgpName() {
        return this.egpName;
    }

    public static EgpContractStatus getByName(String egpName) {
        Optional<EgpContractStatus> egpStatus = Stream.of(EgpContractStatus.values()).filter(status -> status.name().equals(egpName)).findFirst();
        return egpStatus.orElse(NOT_FOUND);
    }

    public static EgpContractStatus getById(Long statusId) {
        Optional<EgpContractStatus> egpStatus = Stream.of(EgpContractStatus.values()).filter(status -> status.id.equals(statusId)).findFirst();
        return egpStatus.orElse(NOT_FOUND);
    }

    public static EgpContractStatus getByEgpName(String egpName) {
        Optional<EgpContractStatus> egpStatus = Stream.of(EgpContractStatus.values()).filter(status -> status.getEgpName().equals(egpName)).findFirst();
        return egpStatus.orElse(NOT_FOUND);
    }

    public static boolean prohibitedStatus(EgpContractStatus status) {
        return PROHIBITED_STATUSES.contains((Object)status);
    }

    public static boolean validStatus(EgpContractStatus status) {
        return VALID_STATUSES.contains((Object)status);
    }

    static {
        PROHIBITED_STATUSES = Arrays.asList(NOT_FOUND);
        VALID_STATUSES = Arrays.asList(VALID);
    }
}

