/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.invoice;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import ru.uss.esf.core.model.RelationKey;
import ru.uss.esf.model.invoice.InvoiceInfo;
import ru.uss.esf.model.invoice.InvoiceMeta;
import ru.uss.esf.model.invoice.abstractinvoice.AbstractInvoice;
import ru.uss.esf.model.invoice.abstractinvoice.RelatedInvoice;

public class InvoiceBuilderUtils {
    private InvoiceBuilderUtils() {
    }

    public static InvoiceMeta getRelatedCancelExist(RelationKey relationKey, Set<InvoiceMeta> parentExists, Collection<String> accessTins) {
        InvoiceMeta found = null;
        for (InvoiceMeta ce : parentExists) {
            if (!relationKey.equalsWithRelation(ce.getRelationKey(), accessTins)) continue;
            found = ce;
            break;
        }
        return found;
    }

    public static RelationKey createRelatedKeyFromInvoice(InvoiceInfo invoice) {
        return new RelationKey(((AbstractInvoice)invoice.getInvoice()).getDate(), ((AbstractInvoice)invoice.getInvoice()).getNum(), InvoiceBuilderUtils.getCreatorTin(invoice), ((AbstractInvoice)invoice.getInvoice()).getCreatorProjectCode());
    }

    public static RelationKey createRelatedKeyFromRelatedInvoice(InvoiceInfo invoice) {
        RelatedInvoice relatedInvoice = ((AbstractInvoice)invoice.getInvoice()).getRelatedInvoice();
        if (relatedInvoice != null && relatedInvoice.getDate() != null) {
            return new RelationKey(relatedInvoice.getDate(), relatedInvoice.getNum(), InvoiceBuilderUtils.getCreatorTin(invoice), ((AbstractInvoice)invoice.getInvoice()).getCreatorProjectCode());
        }
        return null;
    }

    public static String getCreatorTin(InvoiceInfo invoice) {
        return ((AbstractInvoice)invoice.getInvoice()).getCreatorTin();
    }

    public static Set<RelationKey> getRelatedKeys(Collection<InvoiceInfo> invoices) {
        HashSet<RelationKey> relationKeys = new HashSet<RelationKey>();
        for (InvoiceInfo invoice : invoices) {
            RelationKey key = InvoiceBuilderUtils.createRelatedKeyFromRelatedInvoice(invoice);
            if (key == null) continue;
            relationKeys.add(key);
        }
        return relationKeys;
    }

    public static Set<Long> getParentIdentifiers(Set<InvoiceMeta> parentInvoices) {
        HashSet<Long> ids = new HashSet<Long>();
        for (InvoiceMeta ce : parentInvoices) {
            ids.add(ce.getInvoiceId());
        }
        return ids;
    }

    public static Set<RelationKey> getMetaKeys(Set<InvoiceMeta> parentInvoices) {
        HashSet<RelationKey> relationKeys = new HashSet<RelationKey>();
        for (InvoiceMeta meta : parentInvoices) {
            relationKeys.add(meta.getRelationKey());
        }
        return relationKeys;
    }

    public static Set<RelationKey> getInfoKeys(Collection<InvoiceInfo> invoices) {
        HashSet<RelationKey> relationKeys = new HashSet<RelationKey>();
        for (InvoiceInfo info : invoices) {
            relationKeys.add(InvoiceBuilderUtils.createRelatedKeyFromInvoice(info));
        }
        return relationKeys;
    }
}

