/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.invoice;

import java.math.BigDecimal;
import java.util.Date;
import ru.uss.core.utils.TinUtils;
import ru.uss.esf.core.model.RelationKey;
import ru.uss.esf.model.invoice.InvoiceBuilderUtils;
import ru.uss.esf.model.invoice.InvoiceInfo;
import ru.uss.esf.model.invoice.InvoiceStatus;
import ru.uss.esf.model.invoice.abstractinvoice.AbstractInvoice;
import ru.uss.esf.model.invoice.abstractinvoice.InvoiceType;

public class InvoiceMeta {
    private long invoiceId;
    private InvoiceType invoiceType;
    private InvoiceStatus status;
    private Date inputDate;
    private Date date;
    private String num;
    private String registrationNumber;
    private String tin;
    private String sellerAgentTin;
    private String branchTin;
    private Long projectCode;
    private Date relatedDate;
    private String relatedNumber;
    private String relatedRegistrationNumber;
    private BigDecimal totalPriceWithTax;
    private Date lastUpdateDate;
    private RelationKey relationKey;

    public InvoiceMeta() {
    }

    @Deprecated
    public InvoiceMeta(long invoiceId, InvoiceStatus status, InvoiceType invoiceType, BigDecimal totalPriceWithTax, Date date, Date inputDate, String number, String tin, Long projectCode) {
        this.invoiceId = invoiceId;
        this.status = status;
        this.invoiceType = invoiceType;
        this.date = date;
        this.inputDate = inputDate;
        this.num = number;
        this.tin = tin;
        this.projectCode = projectCode;
        this.totalPriceWithTax = totalPriceWithTax;
        this.relationKey = new RelationKey(date, number, tin, projectCode);
    }

    public InvoiceMeta(long invoiceId, String invoiceType, String status, Date date, Date inputDate, String num, String registrationNumber, long tin, Long sellerAgentTin, long branchTin, Long projectCode, Date relatedDate, String relatedNumber, String relatedRegistrationNumber, BigDecimal totalPriceWithTax, Date lastUpdateDate) {
        this.invoiceId = invoiceId;
        this.invoiceType = invoiceType != null ? InvoiceType.valueOf(invoiceType) : null;
        this.status = status != null ? InvoiceStatus.valueOf(status) : null;
        this.date = date;
        this.inputDate = inputDate;
        this.num = num;
        this.registrationNumber = registrationNumber;
        this.tin = TinUtils.convert(tin);
        this.sellerAgentTin = TinUtils.convert(sellerAgentTin);
        this.branchTin = TinUtils.convert(branchTin);
        this.projectCode = projectCode;
        this.relatedDate = relatedDate;
        this.relatedNumber = relatedNumber;
        this.relatedRegistrationNumber = relatedRegistrationNumber;
        this.totalPriceWithTax = totalPriceWithTax;
        this.lastUpdateDate = lastUpdateDate;
        this.relationKey = new RelationKey(this.date, this.num, this.sellerAgentTin != null ? this.sellerAgentTin : this.branchTin, this.projectCode);
    }

    public InvoiceMeta(InvoiceInfo info) {
        this.invoiceId = info.getInvoiceId();
        this.invoiceType = ((AbstractInvoice)info.getInvoice()).getInvoiceType();
        this.status = info.getInvoiceStatus();
        this.date = ((AbstractInvoice)info.getInvoice()).getDate();
        this.inputDate = info.getInputDate();
        this.num = ((AbstractInvoice)info.getInvoice()).getNum();
        this.registrationNumber = info.getRegistrationNumber();
        this.tin = ((AbstractInvoice)info.getInvoice()).getCreatorTin();
        this.projectCode = ((AbstractInvoice)info.getInvoice()).getCreatorProjectCode();
        if (((AbstractInvoice)info.getInvoice()).getRelatedInvoice() != null) {
            this.relatedDate = ((AbstractInvoice)info.getInvoice()).getRelatedInvoice().getDate();
            this.relatedNumber = ((AbstractInvoice)info.getInvoice()).getRelatedInvoice().getNum();
            this.relatedRegistrationNumber = ((AbstractInvoice)info.getInvoice()).getRelatedInvoice().getRegistrationNumber();
        }
        this.totalPriceWithTax = ((AbstractInvoice)info.getInvoice()).getTotalPriceWithTax();
        this.lastUpdateDate = info.getLastUpdateDate();
        this.relationKey = InvoiceBuilderUtils.createRelatedKeyFromInvoice(info);
    }

    @Deprecated
    public InvoiceMeta(long invoiceId, String status, String invoiceType, BigDecimal totalPriceWithTax, Date date, Date inputDate, String number, String tin, Long projectCode) {
        this.invoiceId = invoiceId;
        this.status = status != null ? InvoiceStatus.valueOf(status) : null;
        this.invoiceType = invoiceType != null ? InvoiceType.valueOf(invoiceType) : null;
        this.totalPriceWithTax = totalPriceWithTax;
        this.relationKey = new RelationKey(date, number, tin, projectCode);
        this.inputDate = inputDate;
    }

    public long getInvoiceId() {
        return this.invoiceId;
    }

    public void setInvoiceId(long invoiceId) {
        this.invoiceId = invoiceId;
    }

    public InvoiceStatus getStatus() {
        return this.status;
    }

    public void setStatus(InvoiceStatus status) {
        this.status = status;
    }

    public InvoiceType getInvoiceType() {
        return this.invoiceType;
    }

    public void setInvoiceType(InvoiceType invoiceType) {
        this.invoiceType = invoiceType;
    }

    public RelationKey getRelationKey() {
        return this.relationKey;
    }

    public void setRelationKey(RelationKey relationKey) {
        this.relationKey = relationKey;
    }

    public BigDecimal getTotalPriceWithTax() {
        return this.totalPriceWithTax;
    }

    public void setTotalPriceWithTax(BigDecimal totalPriceWithTax) {
        this.totalPriceWithTax = totalPriceWithTax;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getInputDate() {
        return this.inputDate;
    }

    public void setInputDate(Date inputDate) {
        this.inputDate = inputDate;
    }

    public String getNum() {
        return this.num;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public String getTin() {
        return this.tin;
    }

    public void setTin(String tin) {
        this.tin = tin;
    }

    public String getSellerAgentTin() {
        return this.sellerAgentTin;
    }

    public void setSellerAgentTin(String sellerAgentTin) {
        this.sellerAgentTin = sellerAgentTin;
    }

    public Long getProjectCode() {
        return this.projectCode;
    }

    public void setProjectCode(Long projectCode) {
        this.projectCode = projectCode;
    }

    public Date getRelatedDate() {
        return this.relatedDate;
    }

    public void setRelatedDate(Date relatedDate) {
        this.relatedDate = relatedDate;
    }

    public String getRelatedNumber() {
        return this.relatedNumber;
    }

    public void setRelatedNumber(String relatedNumber) {
        this.relatedNumber = relatedNumber;
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public void setLastUpdateDate(Date lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public String getRegistrationNumber() {
        return this.registrationNumber;
    }

    public void setRegistrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
    }

    public String getRelatedRegistrationNumber() {
        return this.relatedRegistrationNumber;
    }

    public void setRelatedRegistrationNumber(String relatedRegistrationNumber) {
        this.relatedRegistrationNumber = relatedRegistrationNumber;
    }

    public String getBranchTin() {
        return this.branchTin;
    }

    public void setBranchTin(String branchTin) {
        this.branchTin = branchTin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvoiceMeta that = (InvoiceMeta)o;
        if (this.invoiceId != that.invoiceId) {
            return false;
        }
        if (this.date != null ? !this.date.equals(that.date) : that.date != null) {
            return false;
        }
        if (this.num != null ? !this.num.equals(that.num) : that.num != null) {
            return false;
        }
        if (this.registrationNumber != null ? !this.registrationNumber.equals(that.registrationNumber) : that.registrationNumber != null) {
            return false;
        }
        if (this.tin != null ? !this.tin.equals(that.tin) : that.tin != null) {
            return false;
        }
        if (this.relatedDate != null ? !this.relatedDate.equals(that.relatedDate) : that.relatedDate != null) {
            return false;
        }
        if (this.relatedNumber != null ? !this.relatedNumber.equals(that.relatedNumber) : that.relatedNumber != null) {
            return false;
        }
        if (this.relatedRegistrationNumber != null ? !this.relatedRegistrationNumber.equals(that.relatedRegistrationNumber) : that.relatedRegistrationNumber != null) {
            return false;
        }
        return this.projectCode != null ? this.projectCode.equals(that.projectCode) : that.projectCode == null;
    }

    public int hashCode() {
        int result = (int)(this.invoiceId ^ this.invoiceId >>> 32);
        result = 31 * result + (this.date != null ? this.date.hashCode() : 0);
        result = 31 * result + (this.num != null ? this.num.hashCode() : 0);
        result = 31 * result + (this.registrationNumber != null ? this.registrationNumber.hashCode() : 0);
        result = 31 * result + (this.tin != null ? this.tin.hashCode() : 0);
        result = 31 * result + (this.projectCode != null ? this.projectCode.hashCode() : 0);
        result = 31 * result + (this.relatedDate != null ? this.relatedDate.hashCode() : 0);
        result = 31 * result + (this.relatedNumber != null ? this.relatedNumber.hashCode() : 0);
        result = 31 * result + (this.relatedRegistrationNumber != null ? this.relatedRegistrationNumber.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "InvoiceMeta{invoiceId=" + this.invoiceId + ", invoiceType=" + this.invoiceType + ", status=" + (Object)((Object)this.status) + ", date=" + this.date + ", num='" + this.num + '\'' + ", registrationNumber='" + this.registrationNumber + '\'' + ", tin='" + this.tin + '\'' + ", projectCode=" + this.projectCode + ", relatedDate=" + this.relatedDate + ", relatedNumber='" + this.relatedNumber + '\'' + ", relatedRegistrationNumber='" + this.relatedRegistrationNumber + '\'' + ", totalPriceWithTax=" + this.totalPriceWithTax + ", lastUpdateDate=" + this.lastUpdateDate + ", relationKey=" + this.relationKey + '}';
    }
}

