/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.invoice.version.v1;

import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections4.CollectionUtils;
import ru.uss.esf.model.invoice.LegalEntity;
import ru.uss.esf.model.invoice.abstractinvoice.AbstractParticipant;
import ru.uss.esf.model.invoice.version.v1.CustomerTypeV1;
import ru.uss.esf.validation.common.field.ExactDigitsCount;
import ru.uss.esf.validation.common.field.Text;
import ru.uss.esf.validation.common.field.Tin;
import ru.uss.esf.validation.common.relation.NotEmptyIfTargetFieldContains;
import ru.uss.esf.validation.invoice.version.v1.CustomerTinV1;
import ru.uss.esf.validation.invoice.version.v1.field.CustomerTypesV1;

@CustomerTinV1
@NotEmptyIfTargetFieldContains(checkedField="address", targetField="statuses", expectedValues={"NONRESIDENT"}, message="{customerV1.address.notNull}")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Customer")
@Documentation(value="\u041f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044c (C)")
public class CustomerV1
extends AbstractParticipant
implements Serializable,
LegalEntity {
    @Tin(message="{customerV1.tin.format}")
    @Documentation(value="\u0418\u0418\u041d/\u0411\u0418\u041d. \u041c\u043e\u0436\u0435\u0442 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0435\u0441\u043b\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0441\u0442\u0430\u0442\u0443\u0441 CustomerType.NONRESIDENT (C 17)")
    private String tin;
    @Text(min=3, max=3, message="{customerV1.countryCode.size}")
    @Documentation(value="\u041a\u043e\u0434 \u0441\u0442\u0440\u0430\u043d\u044b \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f. \u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e \u0437\u0430\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0435\u0441\u043b\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0441\u0442\u0430\u0442\u0443\u0441 CustomerType.NONRESIDENT \u0438 SellerType.EXPORTER (C 20)")
    private String countryCode;
    @ExactDigitsCount(count=12, message="{customerV1.rnn.digits}")
    @Documentation(value="\u0420\u041d\u041d \u0440\u0435\u043e\u0440\u0433\u0430\u043d\u0438\u0437\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430. \u041c\u043e\u0436\u0435\u0442 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c. (C 17.1)")
    private String rnn;
    @NotNull(message="{customerV1.name.notNull}")
    @Text(min=3, max=400, message="{customerV1.name.size}")
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f (C 18)")
    private @NotNull(message="{customerV1.name.notNull}") String name;
    @Text(min=3, max=400, message="{customerV1.address.size}")
    @Documentation(value="\u0410\u0434\u0440\u0435\u0441 (C 19)")
    private String address;
    @CustomerTypesV1
    @XmlElementWrapper
    @XmlElement(name="status", required=true)
    @Documentation(value="\u0422\u0438\u043f \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f")
    private List<CustomerTypeV1> statuses;
    @Text(min=1, max=255, message="{customerV1.trailer.size}")
    @Documentation(value="\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0441\u0432\u0435\u0434\u0435\u043d\u0438\u044f")
    private String trailer;

    @Override
    public String getTin() {
        return this.tin;
    }

    @Override
    public boolean isLessor() {
        return false;
    }

    @Override
    public void setTin(String tin) {
        this.tin = tin;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getRnn() {
        return this.rnn;
    }

    public void setRnn(String rnn) {
        this.rnn = rnn;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(String address) {
        this.address = address;
    }

    public String getTrailer() {
        return this.trailer;
    }

    public void setTrailer(String value) {
        this.trailer = value;
    }

    public List<CustomerTypeV1> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<CustomerTypeV1> statuses) {
        this.statuses = statuses;
    }

    public boolean containsStatus(CustomerTypeV1 status) {
        return this.statuses != null && this.statuses.contains(status);
    }

    @Override
    public boolean isNonResident() {
        return CollectionUtils.isNotEmpty(this.statuses) && this.statuses.contains(CustomerTypeV1.NONRESIDENT);
    }

    @Override
    public boolean isIndividual() {
        return CollectionUtils.isNotEmpty(this.statuses) && this.statuses.contains(CustomerTypeV1.INDIVIDUAL);
    }

    @Override
    public boolean isRetail() {
        return false;
    }
}

