/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.invoice.version.v1;

import java.math.BigDecimal;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import ru.uss.core.utils.BigDecimalUtils;
import ru.uss.esf.model.invoice.abstractinvoice.AbstractProductShare;
import ru.uss.esf.validation.common.field.DecimalFormat;
import ru.uss.esf.validation.common.field.Text;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ProductShare")
@Documentation(value="\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043f\u043e \u0442\u043e\u0432\u0430\u0440\u0430\u043c (\u0440\u0430\u0431\u043e\u0442\u0430\u043c, \u0443\u0441\u043b\u0443\u0433\u0430\u043c)")
public class ProductShareV1
extends AbstractProductShare {
    @Min(value=1L, message="{productShareV1.number.min}")
    @Max(value=200L, message="{productShareV1.number.max}")
    @XmlElement(required=true)
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 (\u0442\u043e\u0432\u0430\u0440\u0430, \u0443\u0441\u043b\u0443\u0433\u0438) (G 1)")
    private @Min(value=1L, message="{productShareV1.number.min}") @Max(value=200L, message="{productShareV1.number.max}") int productNumber;
    @Digits(integer=12, fraction=6, message="{productShareV1.quantity.digits}")
    @DecimalFormat(message="{productShareV1.quantity.decimalFormat}")
    @Documentation(value="\u041a\u043e\u043b-\u0432\u043e (\u043e\u0431\u044a\u0435\u043c) (H 5)")
    private @Digits(integer=12, fraction=6, message="{productShareV1.quantity.digits}") BigDecimal quantity;
    @NotNull(message="{productShareV1.priceWithoutTax.notNull}")
    @Digits(integer=15, fraction=2, message="{productShareV1.priceWithoutTax.digits}")
    @DecimalFormat(message="{productShareV1.priceWithoutTax.decimalFormat}")
    @XmlElement(required=true)
    @Documentation(value="\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0422\u0420\u0423 \u0431\u0435\u0437 \u0443\u0447\u0435\u0442\u0430 \u041d\u0414\u0421 (H 7)")
    private @NotNull(message="{productShareV1.priceWithoutTax.notNull}") @Digits(integer=15, fraction=2, message="{productShareV1.priceWithoutTax.digits}") BigDecimal priceWithoutTax;
    @Digits(integer=15, fraction=2, message="{productShareV1.exciseAmount.digits}")
    @DecimalFormat(message="{productShareV1.exciseAmount.decimalFormat}")
    @Documentation(value="\u0410\u043a\u0446\u0438\u0437-\u0421\u0443\u043c\u043c\u0430 (H 9)")
    private @Digits(integer=15, fraction=2, message="{productShareV1.exciseAmount.digits}") BigDecimal exciseAmount;
    @NotNull(message="{productShareV1.turnoverSize.notNull}")
    @Digits(integer=15, fraction=2, message="{productShareV1.turnoverSize.digits}")
    @DecimalFormat(message="{productShareV1.turnoverSize.decimalFormat}")
    @XmlElement(required=true)
    @Documentation(value="\u0420\u0430\u0437\u043c\u0435\u0440 \u043e\u0431\u043e\u0440\u043e\u0442\u0430 \u043f\u043e \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 (H 10)")
    private @NotNull(message="{productShareV1.turnoverSize.notNull}") @Digits(integer=15, fraction=2, message="{productShareV1.turnoverSize.digits}") BigDecimal turnoverSize;
    @NotNull(message="{productShareV1.ndsAmount.notNull}")
    @Digits(integer=15, fraction=2, message="{productShareV1.ndsAmount.digits}")
    @DecimalFormat(message="{productShareV1.ndsAmount.decimalFormat}")
    @XmlElement(required=true)
    @Documentation(value="\u041d\u0414\u0421-\u0421\u0443\u043c\u043c\u0430 (H 12)")
    private @NotNull(message="{productShareV1.ndsAmount.notNull}") @Digits(integer=15, fraction=2, message="{productShareV1.ndsAmount.digits}") BigDecimal ndsAmount;
    @NotNull(message="{productShareV1.priceWithTax.notNull}")
    @Digits(integer=15, fraction=2, message="{productShareV1.priceWithTax.digits}")
    @DecimalFormat(message="{productShareV1.priceWithTax.decimalFormat}")
    @XmlElement(required=true)
    @Documentation(value="\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0422\u0420\u0423 \u0441 \u0443\u0447\u0435\u0442\u043e\u043c \u041d\u0414\u0421 (H 13)")
    private @NotNull(message="{productShareV1.priceWithTax.notNull}") @Digits(integer=15, fraction=2, message="{productShareV1.priceWithTax.digits}") BigDecimal priceWithTax;
    @Text(min=1, max=255, message="{productShareV1.additional.size}")
    @Documentation(value="\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 (H 17)")
    private String additional;

    public int getProductNumber() {
        return this.productNumber;
    }

    public void setProductNumber(int productNumber) {
        this.productNumber = productNumber;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal value) {
        this.quantity = BigDecimalUtils.stripTrailingZeros(value);
    }

    public BigDecimal getPriceWithoutTax() {
        return this.priceWithoutTax;
    }

    public void setPriceWithoutTax(BigDecimal value) {
        this.priceWithoutTax = BigDecimalUtils.stripTrailingZeros(value);
    }

    public BigDecimal getExciseAmount() {
        return this.exciseAmount;
    }

    public void setExciseAmount(BigDecimal value) {
        this.exciseAmount = BigDecimalUtils.stripTrailingZeros(value);
    }

    public BigDecimal getTurnoverSize() {
        return this.turnoverSize;
    }

    public void setTurnoverSize(BigDecimal value) {
        this.turnoverSize = BigDecimalUtils.stripTrailingZeros(value);
    }

    public BigDecimal getNdsAmount() {
        return this.ndsAmount;
    }

    public void setNdsAmount(BigDecimal value) {
        this.ndsAmount = BigDecimalUtils.stripTrailingZeros(value);
    }

    public BigDecimal getPriceWithTax() {
        return this.priceWithTax;
    }

    public void setPriceWithTax(BigDecimal value) {
        this.priceWithTax = BigDecimalUtils.stripTrailingZeros(value);
    }

    public String getAdditional() {
        return this.additional;
    }

    public void setAdditional(String additional) {
        this.additional = additional;
    }
}

