/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.model.invoice.version.v1;

import java.math.BigDecimal;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import ru.uss.core.utils.BigDecimalUtils;
import ru.uss.esf.model.invoice.abstractinvoice.AbstractProduct;
import ru.uss.esf.validation.common.field.DecimalFormat;
import ru.uss.esf.validation.common.field.Text;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Product")
@Documentation(value="\u0422\u043e\u0432\u0430\u0440 (\u0440\u0430\u0431\u043e\u0442\u0430, \u0443\u0441\u043b\u0443\u0433\u0430)")
public class ProductV1
extends AbstractProduct {
    @NotNull(message="{productV1.description.notNull}")
    @Text(min=2, max=400, message="{productV1.description.size}")
    @XmlElement(required=true)
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0422\u0420\u0423 (G 2)")
    private @NotNull(message="{productV1.description.notNull}") String description;
    @Size(max=10, message="{productV1.unitCode.digits}")
    @Documentation(value="\u041a\u043e\u0434 \u0442\u043e\u0432\u0430\u0440\u0430 (\u0422\u041d\u0412\u0414) (G 3)")
    private @Size(max=10, message="{productV1.unitCode.digits}") String unitCode;
    @Text(min=1, max=10, message="{productV1.unitNomenclature.size}")
    @Documentation(value="\u0415\u0434.\u0438\u0437\u043c (G 4)")
    private String unitNomenclature;
    @Digits(integer=12, fraction=6, message="{productV1.quantity.digits}")
    @DecimalFormat(message="{productV1.quantity.decimalFormat}")
    @Documentation(value="\u041a\u043e\u043b-\u0432\u043e (\u043e\u0431\u044a\u0435\u043c) (G 5)")
    private @Digits(integer=12, fraction=6, message="{productV1.quantity.digits}") BigDecimal quantity;
    @Digits(integer=12, fraction=6, message="{productV1.unitPrice.digits}")
    @DecimalFormat(message="{productV1.unitPrice.decimalFormat}")
    @Documentation(value="\u0426\u0435\u043d\u0430 (\u0442\u0430\u0440\u0438\u0444) \u0437\u0430 \u0435\u0434\u0438\u043d\u0438\u0446\u0443 \u0422\u0420\u0423 \u0431\u0435\u0437 \u0443\u0447\u0435\u0442\u0430 \u041d\u0414\u0421 (G 6)")
    private @Digits(integer=12, fraction=6, message="{productV1.unitPrice.digits}") BigDecimal unitPrice;
    @NotNull(message="{productV1.priceWithoutTax.notNull}")
    @Digits(integer=15, fraction=2, message="{productV1.priceWithoutTax.digits}")
    @DecimalFormat(message="{productV1.priceWithoutTax.decimalFormat}")
    @XmlElement(required=true)
    @Documentation(value="\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0422\u0420\u0423 \u0431\u0435\u0437 \u0443\u0447\u0435\u0442\u0430 \u041d\u0414\u0421 (G 7)")
    private @NotNull(message="{productV1.priceWithoutTax.notNull}") @Digits(integer=15, fraction=2, message="{productV1.priceWithoutTax.digits}") BigDecimal priceWithoutTax;
    @Digits(integer=12, fraction=2, message="{productV1.exciseRate.digits}")
    @DecimalFormat(message="{productV1.exciseRate.decimalFormat}")
    @Min(value=0L, message="{productV1.exciseRate.min}")
    @Documentation(value="\u0410\u043a\u0446\u0438\u0437-\u0421\u0442\u0430\u0432\u043a\u0430 (G 8)")
    private @Digits(integer=12, fraction=2, message="{productV1.exciseRate.digits}") @Min(value=0L, message="{productV1.exciseRate.min}") BigDecimal exciseRate;
    @Digits(integer=15, fraction=2, message="{productV1.exciseAmount.digits}")
    @DecimalFormat(message="{productV1.exciseAmount.decimalFormat}")
    @Documentation(value="\u0410\u043a\u0446\u0438\u0437-\u0421\u0443\u043c\u043c\u0430 (G 9)")
    private @Digits(integer=15, fraction=2, message="{productV1.exciseAmount.digits}") BigDecimal exciseAmount;
    @NotNull(message="{productV1.turnoverSize.notNull}")
    @Digits(integer=15, fraction=2, message="{productV1.turnoverSize.digits}")
    @DecimalFormat(message="{productV1.turnoverSize.decimalFormat}")
    @XmlElement(required=true)
    @Documentation(value="\u0420\u0430\u0437\u043c\u0435\u0440 \u043e\u0431\u043e\u0440\u043e\u0442\u0430 \u043f\u043e \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 (G 10)")
    private @NotNull(message="{productV1.turnoverSize.notNull}") @Digits(integer=15, fraction=2, message="{productV1.turnoverSize.digits}") BigDecimal turnoverSize;
    @Max(value=100L, message="{productV1.ndsRate.max}")
    @Min(value=0L, message="{productV1.ndsRate.min}")
    @Documentation(value="\u041d\u0414\u0421-\u0421\u0442\u0430\u0432\u043a\u0430 (G 11)")
    private @Max(value=100L, message="{productV1.ndsRate.max}") @Min(value=0L, message="{productV1.ndsRate.min}") Integer ndsRate;
    @NotNull(message="{productV1.ndsAmount.notNull}")
    @Digits(integer=15, fraction=2, message="{productV1.ndsAmount.digits}")
    @DecimalFormat(message="{productV1.ndsAmount.decimalFormat}")
    @XmlElement(required=true)
    @Documentation(value="\u041d\u0414\u0421-\u0421\u0443\u043c\u043c\u0430 (G 12)")
    private @NotNull(message="{productV1.ndsAmount.notNull}") @Digits(integer=15, fraction=2, message="{productV1.ndsAmount.digits}") BigDecimal ndsAmount;
    @NotNull(message="{productV1.priceWithTax.notNull}")
    @Digits(integer=15, fraction=2, message="{productV1.priceWithTax.digits}")
    @DecimalFormat(message="{productV1.priceWithTax.decimalFormat}")
    @XmlElement(required=true)
    @Documentation(value="\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0422\u0420\u0423 \u0441 \u0443\u0447\u0435\u0442\u043e\u043c \u041d\u0414\u0421 (G 13)")
    private @NotNull(message="{productV1.priceWithTax.notNull}") @Digits(integer=15, fraction=2, message="{productV1.priceWithTax.digits}") BigDecimal priceWithTax;
    @Text(min=1, max=20, message="{productV1.applicationNumberInCustomsUnion.size}")
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u0437\u0430\u044f\u0432\u043b\u0435\u043d\u0438\u044f \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u0422\u0421 (G 16)")
    private String applicationNumberInCustomsUnion;
    @Text(min=1, max=255, message="{productV1.additional.size}")
    @Documentation(value="\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 (G 17)")
    private String additional;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    @Override
    public String getUnitCode() {
        return this.unitCode;
    }

    public void setUnitCode(String value) {
        this.unitCode = value;
    }

    public String getUnitNomenclature() {
        return this.unitNomenclature;
    }

    public void setUnitNomenclature(String value) {
        this.unitNomenclature = value;
    }

    @Override
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal value) {
        this.quantity = BigDecimalUtils.stripTrailingZeros(value);
    }

    @Override
    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(BigDecimal value) {
        this.unitPrice = BigDecimalUtils.stripTrailingZeros(value);
    }

    @Override
    public BigDecimal getPriceWithoutTax() {
        return this.priceWithoutTax;
    }

    public void setPriceWithoutTax(BigDecimal value) {
        this.priceWithoutTax = BigDecimalUtils.stripTrailingZeros(value);
    }

    public BigDecimal getExciseRate() {
        return this.exciseRate;
    }

    public void setExciseRate(BigDecimal value) {
        this.exciseRate = BigDecimalUtils.stripTrailingZeros(value);
    }

    @Override
    public BigDecimal getExciseAmount() {
        return this.exciseAmount;
    }

    public void setExciseAmount(BigDecimal value) {
        this.exciseAmount = BigDecimalUtils.stripTrailingZeros(value);
    }

    @Override
    public BigDecimal getTurnoverSize() {
        return this.turnoverSize;
    }

    public void setTurnoverSize(BigDecimal value) {
        this.turnoverSize = BigDecimalUtils.stripTrailingZeros(value);
    }

    @Override
    public Integer getNdsRate() {
        return this.ndsRate;
    }

    public void setNdsRate(Integer value) {
        this.ndsRate = value;
    }

    @Override
    public BigDecimal getNdsAmount() {
        return this.ndsAmount;
    }

    public void setNdsAmount(BigDecimal value) {
        this.ndsAmount = BigDecimalUtils.stripTrailingZeros(value);
    }

    @Override
    public BigDecimal getPriceWithTax() {
        return this.priceWithTax;
    }

    public void setPriceWithTax(BigDecimal value) {
        this.priceWithTax = BigDecimalUtils.stripTrailingZeros(value);
    }

    public String getAdditional() {
        return this.additional;
    }

    public void setAdditional(String value) {
        this.additional = value;
    }

    public String getApplicationNumberInCustomsUnion() {
        return this.applicationNumberInCustomsUnion;
    }

    public void setApplicationNumberInCustomsUnion(String applicationNumberInCustomsUnion) {
        this.applicationNumberInCustomsUnion = applicationNumberInCustomsUnion;
    }
}

